/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.awt.BorderLayout;
import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JViewport;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.model.IChangeableListListener;
import net.anwiba.commons.swing.process.ProcessContextModel;
import net.anwiba.commons.swing.process.ProcessContextModelListModel;
import net.anwiba.commons.swing.process.ProcessItemPanel;
import net.anwiba.commons.swing.utilities.GuiUtilities;
import net.anwiba.commons.thread.process.IProcessManager;

public class ProcessListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JPanel listPanel = new JPanel();
    private final ProcessContextModelListModel model;
    private final IProcessManager manager;
    private final IChangeableListListener<ProcessContextModel> listener;

    public ProcessListPanel(IProcessManager manager, ProcessContextModelListModel model) {
        this.manager = manager;
        Ensure.ensureArgumentNotNull((Object)((Object)model));
        this.setLayout(new BorderLayout());
        this.add("North", this.listPanel);
        this.listPanel.setLayout(new BoxLayout(this.listPanel, 3));
        this.model = model;
        this.listener = new IChangeableListListener<ProcessContextModel>(){

            public void objectsRemoved(Iterable<Integer> indeces, Iterable<ProcessContextModel> models) {
                ProcessListPanel.this.updateView();
            }

            public void objectsAdded(Iterable<Integer> indeces, Iterable<ProcessContextModel> models) {
                ProcessListPanel.this.updateView();
            }

            public void objectsUpdated(Iterable<Integer> indeces, Iterable<ProcessContextModel> oldObjects, Iterable<ProcessContextModel> newObjects) {
                ProcessListPanel.this.updateView();
            }

            public void objectsChanged(Iterable<ProcessContextModel> oldObjects, Iterable<ProcessContextModel> newObjects) {
                ProcessListPanel.this.updateView();
            }
        };
        model.addListModelListener(this.listener);
        this.updateView();
    }

    public void dispose() {
        this.model.removeListModelListener(this.listener);
    }

    protected void updateView() {
        GuiUtilities.invokeLater(() -> {
            this.listPanel.removeAll();
            for (ProcessContextModel process : this.model.getProcessModels()) {
                this.listPanel.add(new ProcessItemPanel(this.manager, process));
            }
            if (!this.isVisible()) {
                return;
            }
            this.revalidate();
            this.repaint();
            Container parent = this.getPaintingParent();
            if (parent != null) {
                parent.repaint();
            }
        });
    }

    public Container getPaintingParent() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            return parent.getParent();
        }
        return parent;
    }
}

