/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.swing.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.swing.process.IProcessMessageContext;
import net.anwiba.commons.swing.process.ProcessMessages;
import net.anwiba.commons.swing.utilities.SpringLayoutUtilities;

public class ProcessMessageContextPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public ProcessMessageContextPanel(IProcessMessageContext context) {
        JPanel head = new JPanel();
        JTextField processField = new JTextField(context.getProcessDescription());
        processField.setColumns(25);
        processField.setEditable(false);
        IMessage message = context.getMessage();
        JTextField timeField = new JTextField(message.getTimeStamp().toString());
        timeField.setColumns(25);
        timeField.setEditable(false);
        JTextField messageField = new JTextField(message.getText());
        messageField.setColumns(25);
        messageField.setEditable(false);
        head.add(new JLabel(ProcessMessages.PROCESS + ":"));
        head.add(processField);
        head.add(new JLabel("Time:"));
        head.add(timeField);
        head.add(new JLabel(ProcessMessages.MESSAGE + ":"));
        head.add(messageField);
        head.add(new JLabel(ProcessMessages.DETAIL + ":"));
        head.add(new JPanel());
        head.setLayout(new SpringLayout());
        SpringLayoutUtilities.makeCompactGrid((Container)head, (int)2, (int)4, (int)6, (int)6, (int)6, (int)6);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)head, "North");
        JPanel body = this.getBody(message);
        contentPanel.add((Component)body, "Center");
        this.setLayout(new GridLayout(1, 1));
        this.add(contentPanel);
    }

    private JPanel getBody(IMessage message) {
        if (message.getThrowable() != null) {
            JPanel body = new JPanel(new BorderLayout());
            body.add(this.createDetailPane(message.getDescription()), "North");
            body.add(this.createDetailPane(Message.toDetailInfo((Throwable)message.getThrowable())), "Center");
            return body;
        }
        JPanel body = new JPanel(new GridLayout(1, 1));
        body.add(this.createDetailPane(message.getDescription()), "North");
        return body;
    }

    private Component createDetailPane(String description) {
        JTextArea textPane = new JTextArea(description);
        textPane.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setPreferredSize(new Dimension(200, 150));
        return scrollPane;
    }
}

