/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.testing.demo;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.junit.jupiter.api.Assertions;

public class DemoUtilities {
    public static final Duration DELAY_TIME = Duration.ofMillis(100L);
    public static final Duration DEFAULT_TIMEOUT_MILLIS = Duration.ofMillis(30000L);
    public static final Font DEFAULT_FIXED_WIDTH_FONT = new Font("Monospaced", 0, 11);
    public static final Font DEFAULT_PROPORTIONAL_FONT = new Font("Dialog", 0, 11);

    private DemoUtilities() {
    }

    public static JDialog createDialog(Component parentComponent) {
        if (parentComponent == null) {
            return new JDialog();
        }
        if (parentComponent instanceof Dialog) {
            return new JDialog((Dialog)parentComponent);
        }
        if (parentComponent instanceof Frame) {
            return new JDialog((Frame)parentComponent);
        }
        return DemoUtilities.createDialog(parentComponent.getParent());
    }

    public static JWindow createWindow(Component parentComponent) {
        if (parentComponent == null) {
            return new JWindow();
        }
        if (parentComponent instanceof Dialog) {
            return new JWindow((Dialog)parentComponent);
        }
        if (parentComponent instanceof Frame) {
            return new JWindow((Frame)parentComponent);
        }
        return DemoUtilities.createWindow(parentComponent.getParent());
    }

    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("Error setting native LAF: " + e);
        }
    }

    public static void expandTreeNode(JTree tree, TreeNode tNode) {
        TreePath tp = new TreePath(((DefaultMutableTreeNode)tNode).getPath());
        tree.expandPath(tp);
        for (int i = 0; i < tNode.getChildCount(); ++i) {
            DemoUtilities.expandTreeNode(tree, tNode.getChildAt(i));
        }
    }

    public static void centerOnScreen(Window window) {
        try {
            Dimension screenSize = window.getToolkit().getScreenSize();
            Dimension windowSize = window.getSize();
            int x = (screenSize.width - windowSize.width) / 2;
            int y = (screenSize.height - windowSize.height) / 2;
            window.setLocation(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Window getWindowForComponent(EventObject event) {
        Object object = event.getSource();
        if (object instanceof Component) {
            return DemoUtilities.getWindowForComponent((Component)object);
        }
        return JOptionPane.getRootFrame();
    }

    public static final Window getWindowForComponent(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof JPopupMenu) {
            return DemoUtilities.getWindowForComponent(((JPopupMenu)component).getInvoker());
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return DemoUtilities.getWindowForComponent(component.getParent());
    }

    public static <T extends Window> void showAndDispose(final Supplier<T> windowSupplier, Consumer<T> afterOpenedTask) {
        final WindowTestCase testCase = new WindowTestCase();
        final Object[] holder = new Object[]{null};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Window window = (Window)windowSupplier.get();
                holder[0] = window;
                Assertions.assertNotNull((Object)window, (String)"The window to show must not be null.");
                if (window instanceof Dialog) {
                    Dialog dialog = (Dialog)window;
                    dialog.setModal(false);
                    Optional.ofNullable(window.getParent()).filter(c -> c instanceof Window).map(c -> (Window)c).ifPresent(w -> DemoUtilities.registerWindow(testCase, w));
                }
                DemoUtilities.registerWindow(testCase, window);
                window.setVisible(true);
                window.toFront();
            }
        };
        DemoUtilities.runOnEventDispatchThread(runnable);
        afterOpenedTask.accept((Window)holder[0]);
        DemoUtilities.runOnEventDispatchThread(() -> testCase.dispose());
        if (testCase.wasOpened()) {
            return;
        }
        Assertions.fail((String)"gui wasn't opened");
    }

    private static void registerWindow(WindowTestCase testCase, Window window) {
        testCase.add(window);
        window.addWindowListener(new TestCaseWindowListener(testCase));
    }

    private static void runOnEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public static JFrame createJFrame() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(0);
        return frame;
    }

    public static void pause() {
        DemoUtilities.pause(DELAY_TIME);
    }

    public static void pause(Duration delay) {
        try {
            Thread.sleep(delay.toMillis());
        }
        catch (InterruptedException exception) {
            Thread.currentThread().isInterrupted();
        }
    }

    private static class TestCaseWindowListener
    extends WindowAdapter {
        private final WindowTestCase testCase;

        public TestCaseWindowListener(WindowTestCase testCase) {
            this.testCase = testCase;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.testCase.removeListensers((Window)e.getComponent());
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.testCase.setOpen((Window)e.getComponent());
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.testCase.removeListensers((Window)e.getComponent());
        }
    }

    private static class WindowTestCase {
        private boolean wasOpened = false;
        private final List<Window> windows = new ArrayList<Window>();

        private WindowTestCase() {
        }

        public void removeListensers(Window window) {
            WindowListener[] windowListeners;
            for (WindowListener windowListener : windowListeners = window.getWindowListeners()) {
                if (!(windowListener instanceof TestCaseWindowListener)) continue;
                window.removeWindowListener(windowListener);
            }
        }

        public void setOpen(Window window) {
            this.wasOpened = true;
        }

        public void dispose() {
            this.windows.stream().filter(w -> w.isDisplayable()).collect(Collectors.toCollection(ArrayDeque::new)).descendingIterator().forEachRemaining(w -> {
                try {
                    if (w.isVisible()) {
                        w.setVisible(false);
                    }
                }
                finally {
                    w.dispose();
                }
            });
        }

        public void add(Window window) {
            this.windows.add(window);
        }

        public boolean wasOpened() {
            return this.wasOpened;
        }
    }
}

