/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.testing.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import net.anwiba.testing.demo.DemoUtilities;
import net.anwiba.testing.demo.component.IconComponent;
import net.anwiba.testing.demo.component.SwingTextPanel;
import org.junit.jupiter.api.Assertions;

public class JFrames {
    public static void show(Icon icon) {
        JFrames.viewer().setIcon(icon).show();
    }

    public static void show(JMenuBar menuBar) {
        JFrames.viewer().setJMenuBar(menuBar).show();
    }

    public static void show(JMenuBar menuBar, Consumer<JFrame> afterOpenedTask) {
        JFrames.viewer().setJMenuBar(menuBar).setAfterOpenedTask(afterOpenedTask).show();
    }

    public static void show(Duration timeout, JMenuBar menuBar, Consumer<JFrame> afterOpenedTask) {
        JFrames.viewer().setTimeout(timeout).setJMenuBar(menuBar).setAfterOpenedTask(afterOpenedTask).show();
    }

    public static void show(JComponent component) {
        JFrames.viewer().setComponent(component).show();
    }

    public static void show(Duration timeout, JComponent component) {
        JFrames.viewer().setTimeout(timeout).setComponent(component).show();
    }

    public static void show(JComponent component, Consumer<JFrame> afterOpenedTask) {
        JFrames.viewer().setComponent(component).setAfterOpenedTask(afterOpenedTask).show();
    }

    public static void show(Duration timeout, JComponent component, Consumer<JFrame> afterOpenedTask) {
        JFrames.viewer().setTimeout(timeout).setComponent(component).setAfterOpenedTask(afterOpenedTask).show();
    }

    public static void show(Duration timeout, Consumer<JFrame> guiBuilderTask, Consumer<JFrame> afterOpenedTask) {
        JFrames.viewer().setTimeout(timeout).setGuiBuilderTask(guiBuilderTask).setAfterOpenedTask(afterOpenedTask).show();
    }

    public static void show(JFrame frame) {
        JFrames.viewer().setFrame(frame).show();
    }

    public static void show(Duration timeout, JFrame frame) {
        JFrames.viewer().setTimeout(timeout).setFrame(frame).show();
    }

    public static void show(Duration timeout, JFrame frame, Consumer<JFrame> afterOpenedTask) {
        JFrames.viewer().setTimeout(timeout).setFrame(frame).setAfterOpenedTask(afterOpenedTask).show();
    }

    public static Viewer viewer() {
        return new Viewer();
    }

    private static class Configuration {
        private final Duration timeout;
        private final Supplier<JFrame> jFrameSupplier;
        private final Consumer<JFrame> guiBuilderTask;
        private final Consumer<JFrame> afterOpenedTask;

        public Configuration(Duration timeout, Supplier<JFrame> jFrameSupplier, Consumer<JFrame> guiBuilderTask, Consumer<JFrame> afterOpenedTask) {
            this.timeout = timeout;
            this.jFrameSupplier = jFrameSupplier;
            this.afterOpenedTask = afterOpenedTask;
            this.guiBuilderTask = guiBuilderTask;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Consumer<JFrame> getGuiBuilderTask() {
            return this.guiBuilderTask;
        }

        public Consumer<JFrame> getAfterOpenedTask() {
            return this.afterOpenedTask;
        }

        public Supplier<JFrame> getJFrameSupplier() {
            return this.jFrameSupplier;
        }
    }

    public static class Viewer {
        private Duration timeout = DemoUtilities.DEFAULT_TIMEOUT_MILLIS;
        private Supplier<JFrame> jFrameSupplier = () -> DemoUtilities.createJFrame();
        private Consumer<JFrame> guiBuilderTask = f -> {};
        private Consumer<JFrame> afterOpenedTask = f -> DemoUtilities.pause();

        Viewer() {
        }

        public Viewer setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Viewer setjFrameSupplier(Supplier<JFrame> jFrameSupplier) {
            this.jFrameSupplier = jFrameSupplier;
            return this;
        }

        public Viewer setFrame(JFrame frame) {
            Assertions.assertNotNull((Object)frame, (String)"The frame to show must not be null.");
            this.jFrameSupplier = () -> frame;
            return this;
        }

        public Viewer setGuiBuilderTask(Consumer<JFrame> guiBuilderTask) {
            this.guiBuilderTask = guiBuilderTask;
            return this;
        }

        public Viewer setComponent(JComponent component) {
            Assertions.assertNotNull((Object)component, (String)"The component to show must not be null.");
            this.guiBuilderTask = frame -> {
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)component, "Center");
                frame.pack();
            };
            return this;
        }

        public Viewer setJMenuBar(JMenuBar menuBar) {
            Assertions.assertNotNull((Object)menuBar, (String)"The component to show must not be null.");
            this.guiBuilderTask = frame -> {
                frame.getContentPane().setLayout(new BorderLayout());
                frame.setJMenuBar(menuBar);
                frame.pack();
            };
            return this;
        }

        public Viewer setIcon(Icon icon) {
            Assertions.assertNotNull((Object)icon, (String)"The icon to show must not be null.");
            this.setComponent(new IconComponent(icon));
            return this;
        }

        public Viewer setText(CharSequence text) {
            Assertions.assertNotNull((Object)text, (String)"The text to show must not be null.");
            this.setComponent(new SwingTextPanel(text).getContent());
            return this;
        }

        public Viewer setText(CharSequence text, Font font) {
            Assertions.assertNotNull((Object)text, (String)"The text to show must not be null.");
            Assertions.assertNotNull((Object)font, (String)"The font to show must not be null.");
            this.setComponent(new SwingTextPanel(text, font).getContent());
            return this;
        }

        public Viewer setAfterOpenedTask(Consumer<JFrame> afterOpenedTask) {
            this.afterOpenedTask = afterOpenedTask;
            return this;
        }

        public void show() {
            Viewer.show(new Configuration(this.timeout, this.jFrameSupplier, this.guiBuilderTask, this.afterOpenedTask));
        }

        private static void show(Configuration configuration) {
            Function<Configuration, JFrame> windowFactory = c -> {
                JFrame frame = c.getJFrameSupplier().get();
                c.getGuiBuilderTask().accept(frame);
                DemoUtilities.centerOnScreen(frame);
                return frame;
            };
            Supplier<JFrame> windowSupplier = () -> (JFrame)windowFactory.apply(configuration);
            Optional.ofNullable(configuration.getTimeout()).ifPresentOrElse(t -> Assertions.assertTimeoutPreemptively((Duration)t, () -> Viewer.lambda$show$8((Supplier)windowSupplier, configuration)), () -> DemoUtilities.showAndDispose(windowSupplier, configuration.getAfterOpenedTask()));
        }

        private static /* synthetic */ void lambda$show$8(Supplier windowSupplier, Configuration configuration) throws Throwable {
            DemoUtilities.showAndDispose(windowSupplier, configuration.getAfterOpenedTask());
        }
    }
}

