/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.testing.demo;

import java.awt.BorderLayout;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JDialog;
import javax.swing.JFrame;
import net.anwiba.testing.demo.DemoUtilities;
import org.junit.jupiter.api.Assertions;

public class JDialogs {
    public static <T extends JDialog> void show(Function<JFrame, T> dialogFactory) {
        JDialogs.viewer(dialogFactory).show();
    }

    public static <T extends JDialog> void show(Duration timeout, Function<JFrame, T> dialogFactory) {
        JDialogs.viewer(dialogFactory).setTimeout(timeout).show();
    }

    public static <T extends JDialog> void show(Function<JFrame, T> dialogFactory, Consumer<T> afterOpenedTask) {
        JDialogs.viewer(dialogFactory).setAfterOpenedTask(afterOpenedTask).show();
    }

    public static <T extends JDialog> Viewer<T> viewer(Function<JFrame, T> dialogFactory) {
        return new Viewer<T>(dialogFactory);
    }

    public static class Viewer<T extends JDialog> {
        private Duration timeout = DemoUtilities.DEFAULT_TIMEOUT_MILLIS;
        private final Supplier<JFrame> jFrameSupplier = () -> DemoUtilities.createJFrame();
        private Consumer<T> afterOpenedTask = f -> DemoUtilities.pause();
        private final Function<JFrame, T> dialogFactory;

        Viewer(Function<JFrame, T> dialogFactory) {
            Assertions.assertNotNull(dialogFactory, (String)"The dialog factory must not be null.");
            this.dialogFactory = dialogFactory;
        }

        public Viewer<T> setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Viewer<T> setAfterOpenedTask(Consumer<T> afterOpenedTask) {
            this.afterOpenedTask = afterOpenedTask;
            return this;
        }

        public void show() {
            this.show(new Configuration<T>(this.timeout, this.dialogFactory, this.jFrameSupplier, this.afterOpenedTask));
        }

        private void show(Configuration<T> configuration) {
            Function<Configuration, JDialog> windowFactory = c -> {
                JFrame frame = c.getJFrameSupplier().get();
                frame.getContentPane().setLayout(new BorderLayout());
                DemoUtilities.centerOnScreen(frame);
                return (JDialog)c.getDialogFactory().apply(frame);
            };
            Supplier<JDialog> windowSupplier = () -> (JDialog)windowFactory.apply(configuration);
            Optional.ofNullable(configuration.getTimeout()).ifPresentOrElse(t -> Assertions.assertTimeoutPreemptively((Duration)t, () -> Viewer.lambda$show$4((Supplier)windowSupplier, configuration)), () -> DemoUtilities.showAndDispose(windowSupplier, configuration.getAfterOpenedTask()));
        }

        private static /* synthetic */ void lambda$show$4(Supplier windowSupplier, Configuration configuration) throws Throwable {
            DemoUtilities.showAndDispose(windowSupplier, configuration.getAfterOpenedTask());
        }
    }

    private static class Configuration<T extends JDialog> {
        private final Duration timeout;
        private final Supplier<JFrame> jFrameSupplier;
        private final Consumer<T> afterOpenedTask;
        private final Function<JFrame, T> dialogFactory;

        public Configuration(Duration timeout, Function<JFrame, T> dialogFactory, Supplier<JFrame> jFrameSupplier, Consumer<T> afterOpenedTask) {
            this.timeout = timeout;
            this.dialogFactory = dialogFactory;
            this.jFrameSupplier = jFrameSupplier;
            this.afterOpenedTask = afterOpenedTask;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Consumer<T> getAfterOpenedTask() {
            return this.afterOpenedTask;
        }

        public Supplier<JFrame> getJFrameSupplier() {
            return this.jFrameSupplier;
        }

        public Function<JFrame, T> getDialogFactory() {
            return this.dialogFactory;
        }
    }
}

