/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.thread.cancel.Canceler;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.cancel.ICancelerProvider;
import net.anwiba.commons.thread.process.IProcess;
import net.anwiba.commons.thread.process.IProcessContext;
import net.anwiba.commons.thread.process.IProcessIdentfier;
import net.anwiba.commons.thread.process.IProcessList;
import net.anwiba.commons.thread.process.IProcessListener;
import net.anwiba.commons.thread.process.IProcessManager;
import net.anwiba.commons.thread.process.ProcessMonitor;
import net.anwiba.commons.thread.process.ProcessRunner;
import net.anwiba.commons.thread.process.ProcessSequencer;
import net.anwiba.commons.thread.queue.IWorkQueue;
import net.anwiba.commons.thread.queue.IWorkQueueFactory;

public class ProcessManager
implements IProcessManager,
IProcessList {
    private static ILogger logger = Logging.getLogger((String)ProcessManager.class.getName());
    private final Set<IProcessIdentfier> processes = new HashSet<IProcessIdentfier>();
    private final List<IProcessListener> processManagerListeners = new ArrayList<IProcessListener>();
    private final Map<String, IWorkQueue> workQueues = new HashMap<String, IWorkQueue>();
    private final IWorkQueueFactory workQueueFactory;
    private final Object mutex = new Object();

    public ProcessManager(IWorkQueueFactory workQueuesFactory) {
        this.workQueueFactory = workQueuesFactory;
    }

    @Override
    public void execute(IProcess process) {
        this.execute(() -> new Canceler(process.isCancelable()), process);
    }

    @Override
    public void execute(ICanceler canceler, IProcess process) {
        if (process.isPeriodic()) {
            throw new IllegalStateException();
        }
        this.execute(() -> canceler, process);
    }

    private IProcessIdentfier next() {
        IProcessIdentfier nextId = null;
        while (this.processes.contains(nextId = ProcessSequencer.getNextId())) {
        }
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ICancelerProvider cancelerProvider, IProcess process) {
        IWorkQueue workQueue;
        ProcessManager processManager = this;
        synchronized (processManager) {
            if (!this.workQueues.containsKey(process.getQueueName())) {
                this.workQueues.put(process.getQueueName(), this.workQueueFactory.create(logger, process.getQueueName()));
            }
            workQueue = this.workQueues.get(process.getQueueName());
        }
        IProcessIdentfier processIdentfier = this.next();
        ProcessMonitor monitor = new ProcessMonitor(processIdentfier, process.getDescription());
        workQueue.execute(new ProcessRunner(monitor, cancelerProvider, this, processIdentfier, process));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireProcessStarted(IProcessContext context) {
        ArrayList<IProcessListener> listeners = new ArrayList<IProcessListener>();
        List<IProcessListener> list = this.processManagerListeners;
        synchronized (list) {
            listeners.addAll(this.processManagerListeners);
        }
        for (IProcessListener listener : listeners) {
            listener.processStarted(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireProcessFinished(IProcessIdentfier processIdentfier) {
        ArrayList<IProcessListener> listeners = new ArrayList<IProcessListener>();
        List<IProcessListener> list = this.processManagerListeners;
        synchronized (list) {
            listeners.addAll(this.processManagerListeners);
        }
        for (IProcessListener listener : listeners) {
            listener.processFinished(processIdentfier);
            if (this.processes.size() != 0) continue;
            listener.allProgressesFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProcessListener(IProcessListener listener) {
        List<IProcessListener> list = this.processManagerListeners;
        synchronized (list) {
            this.processManagerListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProgressListener(IProcessListener listener) {
        List<IProcessListener> list = this.processManagerListeners;
        synchronized (list) {
            this.processManagerListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started(IProcessContext context) {
        Object object = this.mutex;
        synchronized (object) {
            this.processes.add(context.getProcessIdentfier());
        }
        this.fireProcessStarted(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(IProcessIdentfier processIdentfier) {
        Object object = this.mutex;
        synchronized (object) {
            this.processes.remove(processIdentfier);
        }
        this.fireProcessFinished(processIdentfier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.processes.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ProcessManager processManager = this;
        synchronized (processManager) {
            for (IWorkQueue workQueue : this.workQueues.values()) {
                workQueue.shutdown();
            }
        }
    }

    @Override
    public void remove(IProcessIdentfier identfier) {
        this.workQueues.values().forEach(q -> q.remove(identfier));
    }

    @Override
    public void cancel(IProcessIdentfier identfier) {
        this.workQueues.values().forEach(q -> q.cancel(identfier));
        this.remove(identfier);
    }
}

