/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.cancel;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.cancel.ICancelerListener;

public class Canceler
implements ICanceler {
    private static ILogger logger = Logging.getLogger(Canceler.class);
    private static final long serialVersionUID = -1L;
    private volatile boolean isCanceled;
    private final boolean isEnabled;
    private final List<ICancelerListener> listeners = new ArrayList<ICancelerListener>();

    public Canceler(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public void cancel() {
        if (this.isCanceled) {
            return;
        }
        this.isCanceled = true;
        if (!this.isEnabled) {
            return;
        }
        this.fireCanceled();
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled && this.isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void check() throws CanceledException {
        if (this.isCanceled()) {
            throw new CanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCancelerListener(ICancelerListener listener) {
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCancelerListener(ICancelerListener listener) {
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireCanceled() {
        ArrayList<ICancelerListener> currentListeners;
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            currentListeners = new ArrayList<ICancelerListener>(this.listeners);
        }
        for (ICancelerListener listener : currentListeners) {
            try {
                listener.canceled();
            }
            catch (IllegalStateException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage());
                logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllCancelerListener() {
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
    }
}

