/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.job;

import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.job.ExcecutionFaildException;
import net.anwiba.commons.thread.job.IDescribedTask;
import net.anwiba.commons.thread.job.IJob;
import net.anwiba.commons.thread.job.IJobConfiguration;

public class Job
implements IJob {
    private final IJobConfiguration configuration;

    public Job(IJobConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void excecute(IMessageCollector monitor, ICanceler canceler) throws ExcecutionFaildException, CanceledException {
        for (IDescribedTask tasks : this.configuration.getSubTasks()) {
            if (canceler.isCanceled()) {
                return;
            }
            monitor.setNote(tasks.getDescription());
            tasks.run(monitor, canceler);
        }
    }

    @Override
    public String getTitle() {
        return this.configuration.getTitle();
    }

    @Override
    public String getDescription() {
        return this.configuration.getDescription();
    }

    @Override
    public String getText() {
        return this.configuration.getText();
    }
}

