/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.result;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import net.anwiba.commons.lang.exception.UnreachableCodeReachedException;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageException;
import net.anwiba.commons.message.MessageType;

public class CommentedResult<O> {
    private static IMessage DEFAULT_SUCCESS_MESSAGE = Message.builder().setText("OK").setInfo().build();
    private O value;
    private IMessage message;

    public static <O> CommentedResult<O> success() {
        return new CommentedResult<Object>(null, DEFAULT_SUCCESS_MESSAGE);
    }

    public static <O> CommentedResult<O> success(O value) {
        return new CommentedResult<O>(value, DEFAULT_SUCCESS_MESSAGE);
    }

    public static <O> CommentedResult<O> success(O value, String comment) {
        return new CommentedResult<O>(value, Message.builder().setText(comment).setInfo().build());
    }

    public static <O> CommentedResult<O> success(O value, String comment, String description) {
        return new CommentedResult<O>(value, Message.builder().setText(comment).setDescription(description).setInfo().build());
    }

    public static <O> CommentedResult<O> unsatisfied(String comment) {
        return new CommentedResult<Object>(null, Message.builder().setText(comment).setWarning().build());
    }

    public static <O> CommentedResult<O> unsatisfied(O value, String comment) {
        return new CommentedResult<O>(value, Message.builder().setText(comment).setWarning().build());
    }

    public static <O> CommentedResult<O> unsatisfied(O value, String comment, String description) {
        return new CommentedResult<O>(value, Message.builder().setText(comment).setDescription(description).setWarning().build());
    }

    public static <O> CommentedResult<O> failure(Throwable throwable) {
        return new CommentedResult<Object>(null, Message.builder().setText(throwable.getMessage()).setThrowable(throwable).setError().build());
    }

    public static <O> CommentedResult<O> failure(String comment, Throwable throwable) {
        return new CommentedResult<Object>(null, Message.builder().setText(comment).setThrowable(throwable).setError().build());
    }

    public static <O> CommentedResult<O> failure(String comment, String description, Throwable throwable) {
        return new CommentedResult<Object>(null, Message.builder().setText(comment).setDescription(description).setThrowable(throwable).setError().build());
    }

    public static <O> CommentedResult<O> failure(String comment, String description) {
        return new CommentedResult<Object>(null, Message.builder().setText(comment).setDescription(description).setError().build());
    }

    public static <O> CommentedResult<O> failure(String comment) {
        return new CommentedResult<Object>(null, Message.builder().setText(comment).setError().build());
    }

    public static <O, E extends Exception> CommentedResult<O> from(IOptional<O, E> optional) {
        try {
            if (optional.isSuccessful()) {
                return CommentedResult.success(optional.get());
            }
        }
        catch (Throwable exception) {
            throw new UnreachableCodeReachedException(exception);
        }
        return CommentedResult.failure(optional.getCause());
    }

    public CommentedResult(O value, IMessage message) {
        this.value = value;
        this.message = message;
    }

    public IOptional<O, MessageException> optional() {
        if (this.isSuccessful()) {
            return Optional.of(MessageException.class, this.value);
        }
        return Optional.failed(MessageException.class, (Exception)new MessageException(this.message));
    }

    public boolean isSuccessful() {
        return !Objects.equals(this.message.getMessageType(), MessageType.ERROR);
    }

    public boolean isUnsatisfied() {
        return !Objects.equals(this.message.getMessageType(), MessageType.WARNING);
    }

    public boolean isFailed() {
        return Objects.equals(this.message.getMessageType(), MessageType.ERROR);
    }

    public boolean contains(O value) {
        return this.isSuccessful() && Objects.equals(this.value, value);
    }

    public O get() throws MessageException {
        if (this.isSuccessful()) {
            return this.value;
        }
        throw new MessageException(this.message);
    }

    public O getOr(Supplier<O> supplier) {
        if (this.isSuccessful()) {
            return this.value;
        }
        return supplier.get();
    }

    public O getOrThrow() {
        if (this.isSuccessful()) {
            return this.value;
        }
        NoSuchElementException noSuchElementException = new NoSuchElementException("no success value");
        noSuchElementException.initCause((Throwable)new MessageException(this.message));
        throw noSuchElementException;
    }

    public MessageException getFailureOrThrow() {
        if (this.isSuccessful()) {
            throw new NoSuchElementException("no failure value");
        }
        return new MessageException(this.message);
    }

    public IMessage getComment() {
        return this.message;
    }
}

