/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.job;

import net.anwiba.commons.lang.collection.IMutableObjectList;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.thread.job.DescribedTaskBuilder;
import net.anwiba.commons.thread.job.IDescribedTask;
import net.anwiba.commons.thread.job.IJob;
import net.anwiba.commons.thread.job.IJobConfiguration;
import net.anwiba.commons.thread.job.ITask;
import net.anwiba.commons.thread.job.Job;

public class JobBuilder {
    private String title;
    private String text;
    private String description;
    private final IMutableObjectList<IDescribedTask> taskLists = new ObjectList();

    public IJob build() {
        return new Job(new IJobConfiguration(){

            @Override
            public String getTitle() {
                return JobBuilder.this.title;
            }

            @Override
            public String getText() {
                return JobBuilder.this.text;
            }

            @Override
            public String getDescription() {
                return JobBuilder.this.description;
            }

            @Override
            public IObjectList<IDescribedTask> getSubTasks() {
                return JobBuilder.this.taskLists;
            }
        });
    }

    public JobBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public JobBuilder setText(String text) {
        this.text = text;
        return this;
    }

    public JobBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public JobBuilder addDescribedTask(IDescribedTask task) {
        this.taskLists.add((Object[])new IDescribedTask[]{task});
        return this;
    }

    public JobBuilder addDescribedTask(String describtion, ITask task) {
        this.taskLists.add((Object[])new IDescribedTask[]{new DescribedTaskBuilder().setDescription(describtion).setTask(task).build()});
        return this;
    }
}

