/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.monitor;

import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.message.Message;

public class ThreadMonitor {
    private static final ILogger logger = Logging.getLogger((String)ThreadMonitor.class.getName());
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final Map<Long, ThreadObject> blockedThreads = new ConcurrentHashMap<Long, ThreadObject>();
    private final long limit;

    public ThreadMonitor(long limit) {
        this.limit = limit;
    }

    public void run(IMessageCollector collector) {
        ThreadInfo[] threads;
        for (ThreadInfo thread : threads = this.threadMXBean.dumpAllThreads(true, true)) {
            long created;
            Long threadId = thread.getThreadId();
            if (!Objects.equals((Object)thread.getThreadState(), (Object)Thread.State.BLOCKED)) {
                this.blockedThreads.remove(threadId);
                continue;
            }
            long now = System.currentTimeMillis();
            ThreadObject oldInfo = this.blockedThreads.putIfAbsent(threadId, new ThreadObject(thread.getThreadId(), now));
            if (oldInfo == null || now - (created = oldInfo.getCreated()) < this.limit) continue;
            String threadDump = ThreadMonitor.getThreadDump(threads);
            if (!Objects.equals((Object)thread.getThreadState(), (Object)Thread.State.BLOCKED)) {
                this.blockedThreads.remove(threadId);
                continue;
            }
            IMessage message = Message.builder().error().text("Thread '" + thread.getThreadName() + "' bocked").description(threadDump).build();
            logger.warning(message.getText());
            logger.debug(message.getDescription());
            collector.addMessage(message);
            return;
        }
    }

    private static String getThreadDump(ThreadInfo[] threads) {
        StringBuilder out = new StringBuilder();
        for (ThreadInfo thread : threads) {
            out.append(String.format("name=%s | id=%d | prio=%d | state=%s", new Object[]{thread.getThreadName(), thread.getThreadId(), thread.getPriority(), thread.getThreadState()}));
            out.append('\n');
            if (Objects.equals((Object)thread.getThreadState(), (Object)Thread.State.BLOCKED)) {
                out.append(String.format("id=%d | count=%d | blocked=%d ms | lock=%s", thread.getLockOwnerId(), thread.getBlockedCount(), thread.getBlockedTime(), Optional.of((Object)thread.getLockInfo()).convert(i -> i.getClassName()).getOr(() -> "Unkown")));
                out.append('\n');
            }
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                monitor.getClassName();
            }
            for (StackTraceElement element : thread.getStackTrace()) {
                out.append(element.toString()).append('\n');
            }
            out.append('\n');
        }
        return out.toString();
    }

    private class ThreadObject {
        private final long created;
        private final long id;

        public ThreadObject(long id, long created) {
            this.id = id;
            this.created = created;
        }

        public long getCreated() {
            return this.created;
        }

        public long getId() {
            return this.id;
        }
    }
}

