/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.process;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.message.IMessageCollector;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.process.AbstractProcess;
import net.anwiba.commons.thread.process.IProcess;
import net.anwiba.commons.thread.process.IProcessExecutable;
import net.anwiba.commons.thread.process.IProcessIdentfier;

public class ProcessBuilder {
    private String queueName = "METADATA_IO";
    private String description = "";
    private boolean isCancelable = true;
    private IProcessExecutable executable = (m, c, i) -> {};
    private Duration delay = null;

    public ProcessBuilder setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public ProcessBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ProcessBuilder setExecutable(IProcessExecutable executable) {
        this.executable = executable;
        return this;
    }

    public ProcessBuilder setCancelable(boolean isCancelable) {
        this.isCancelable = isCancelable;
        return this;
    }

    public ProcessBuilder setDelay(Duration delay) {
        this.delay = delay;
        return this;
    }

    public IProcess build() {
        return new AbstractProcess(this.queueName, this.description, this.isCancelable){

            @Override
            public boolean isPeriodic() {
                return ProcessBuilder.this.delay != null && !Duration.ZERO.equals(ProcessBuilder.this.delay);
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return ProcessBuilder.this.delay == null ? 0L : unit.convert(ProcessBuilder.this.delay);
            }

            @Override
            public void execute(IMessageCollector processMonitor, ICanceler canceler, IProcessIdentfier processIdentfier) throws CanceledException {
                ProcessBuilder.this.executable.execute(processMonitor, canceler, processIdentfier);
            }
        };
    }
}

