/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.program;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.exception.CanceledException;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.thread.cancel.Canceler;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.cancel.ICancelerListener;
import net.anwiba.commons.thread.program.IProgramLauncher;
import net.anwiba.commons.utilities.OperationSystemUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class ProgramLauncher
implements IProgramLauncher {
    private static ILogger logger = Logging.getLogger((String)ProgramLauncher.class.getName());
    private IConsumer<InputStream, IOException> inputStreamConsumer = null;
    private IConsumer<InputStream, IOException> errorStreamConsumer = null;
    private boolean isWaitFor = false;
    private String command = null;
    private final List<String> arguments = new ArrayList<String>();

    @Override
    public IProgramLauncher waitNot() {
        this.isWaitFor = false;
        return this;
    }

    @Override
    public IProgramLauncher waitFor() {
        this.isWaitFor = true;
        return this;
    }

    @Override
    public IProgramLauncher streamToLogger() {
        this.inputStreamConsumer(this.createStreamConsumer(ILevel.DEBUG));
        this.errorStreamConsumer(this.createStreamConsumer(ILevel.ERROR));
        return this;
    }

    private IConsumer<InputStream, IOException> createStreamConsumer(ILevel level) {
        return input -> {
            StringBuffer buffer = new StringBuffer();
            try {
                int value = 0;
                block14: while ((value = input.read()) > 0) {
                    switch (value) {
                        case 10: {
                            logger.log(level, buffer.toString());
                            buffer = new StringBuffer();
                            continue block14;
                        }
                    }
                    buffer.append((char)value);
                }
                logger.log(level, buffer.toString());
            }
            catch (IOException exception1) {
                logger.log(level, buffer.toString());
                logger.log(ILevel.DEBUG, exception1.getMessage(), (Throwable)exception1);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException exception) {
                    logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                }
            }
        };
    }

    @Override
    public IProgramLauncher command(String command) {
        this.command = command;
        return this;
    }

    @Override
    public IProgramLauncher argument(String argument) {
        this.arguments.add(argument);
        return this;
    }

    @Override
    public IProgramLauncher errorStreamConsumer(IConsumer<InputStream, IOException> errorStreamConsumer) {
        if (errorStreamConsumer == null) {
            return this;
        }
        this.errorStreamConsumer = errorStreamConsumer;
        return this;
    }

    @Override
    public IProgramLauncher inputStreamConsumer(IConsumer<InputStream, IOException> inputStreamConsumer) {
        if (inputStreamConsumer == null) {
            return this;
        }
        this.inputStreamConsumer = inputStreamConsumer;
        return this;
    }

    @Override
    public Process launch() throws IOException, CanceledException {
        return this.launch(Canceler.DummyCanceler);
    }

    @Override
    public Process launch(ICanceler canceler) throws IOException, CanceledException {
        ArrayList<String> command = new ArrayList<String>();
        if (OperationSystemUtilities.isLinux() || OperationSystemUtilities.isBSD() || OperationSystemUtilities.isUnix()) {
            command.add("sh");
            command.add("-c");
        } else if (OperationSystemUtilities.isWindows()) {
            command.add("cmd");
            command.add("/c");
        }
        String commandString = this.create(this.command, this.arguments);
        Optional.of((Object)commandString).consume(c -> command.add((String)c));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Optional.of(this.inputStreamConsumer).consume(consumer -> processBuilder.redirectError(ProcessBuilder.Redirect.PIPE));
        Optional.of(this.errorStreamConsumer).consume(consumer -> processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE));
        Process process = processBuilder.start();
        Optional.of(IOException.class, this.inputStreamConsumer).consume(consumer -> consumer.consume((Object)process.getInputStream()));
        Optional.of(IOException.class, this.errorStreamConsumer).consume(consumer -> consumer.consume((Object)process.getErrorStream()));
        if (this.isWaitFor) {
            ICancelerListener listener = () -> process.destroy();
            try {
                canceler.addCancelerListener(listener);
                process.waitFor();
            }
            catch (InterruptedException exception) {
                throw new CanceledException();
            }
            finally {
                canceler.removeCancelerListener(listener);
            }
        }
        return process;
    }

    private String create(String command, List<String> arguments) {
        if (StringUtilities.isNullOrEmpty((String)command) && arguments.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Optional.of((Object)command).consume(c -> {
            builder.append((String)c);
            builder.append(" ");
        });
        boolean flag = false;
        for (String argument : arguments) {
            if (flag) {
                builder.append(" ");
            }
            builder.append(argument);
            flag = true;
        }
        return builder.toString();
    }
}

