/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.anwiba.commons.resource.utilities.IoUtilities;

public class ZipUtilities {
    public static void zipFile(File sourceFile, File destinationFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);){
            ZipUtilities.zipFile(sourceFile, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void zipFile(File sourceFile, OutputStream destinationOutputStream) throws IOException {
        ZipUtilities.zipFile(new File[]{sourceFile}, destinationOutputStream);
    }

    public static void zipFile(File[] sourceFiles, OutputStream destinationOutputStream) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(destinationOutputStream);
            File[] fileArray = sourceFiles;
            int n = sourceFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceFile = fileArray[n2];
                if (!sourceFile.exists()) {
                    throw new IllegalArgumentException("Source file '" + sourceFile + "' does not exist.");
                }
                if (sourceFile.isFile()) {
                    ZipUtilities.addFile(zipOutputStream, sourceFile, "");
                } else {
                    ZipUtilities.addDirectory(zipOutputStream, sourceFile, "");
                }
                ++n2;
            }
            zipOutputStream.finish();
        }
        catch (Throwable throwable) {
            IoUtilities.close(zipOutputStream);
            throw throwable;
        }
        IoUtilities.close((Closeable)zipOutputStream);
    }

    private static void addFile(ZipOutputStream zipOutputStream, File sourceFile, String folder) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream inFis = new FileInputStream(sourceFile);){
            ZipEntry zipentry = new ZipEntry(String.valueOf(folder) + sourceFile.getName());
            zipentry.setMethod(8);
            zipOutputStream.putNextEntry(zipentry);
            IoUtilities.pipe((InputStream)inFis, (OutputStream)zipOutputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addDirectory(ZipOutputStream zipOutputStream, File directory, String folder) throws IOException {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File inFile = fileArray[n2];
            if (inFile.isFile()) {
                ZipUtilities.addFile(zipOutputStream, inFile, folder);
            } else {
                ZipUtilities.addDirectory(zipOutputStream, inFile, String.valueOf(folder) + inFile.getName() + "/");
            }
            ++n2;
        }
    }
}

