/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.string.StringUtilities;

public final class StringToDateConverter
implements IConverter<String, Date, RuntimeException> {
    private final SimpleDateFormat format;

    public StringToDateConverter(SimpleDateFormat format) {
        this.format = format;
    }

    public Date convert(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return null;
        }
        try {
            return this.format.parse(value);
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }
}

