/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import net.jafama.FastMath;

public class MathWrapper {
    private static boolean fast = !Boolean.getBoolean("net.anwiba.math.fast.disabled");
    public static final double PI = Math.PI;
    public static final double E = Math.E;

    public static float abs(float value) {
        return Math.abs(value);
    }

    public static double abs(double value) {
        return Math.abs(value);
    }

    public static float min(float value, float other) {
        return Math.min(value, other);
    }

    public static int min(int value, int other) {
        return Math.min(value, other);
    }

    public static double min(double value, double other) {
        return Math.min(value, other);
    }

    public static float max(float value, float other) {
        return Math.max(value, other);
    }

    public static double max(double value, double other) {
        return Math.max(value, other);
    }

    public static int max(int value, int other) {
        return Math.max(value, other);
    }

    public static double IEEEremainder(double f1, double f2) {
        return Math.IEEEremainder(f1, f2);
    }

    public static double random() {
        return Math.random();
    }

    public static double tan(double value) {
        if (fast) {
            return FastMath.tan((double)value);
        }
        return Math.tan(value);
    }

    public static double atan(double value) {
        if (fast) {
            return FastMath.atan((double)value);
        }
        return Math.atan(value);
    }

    public static double atan2(double x, double y) {
        if (fast) {
            return FastMath.atan2((double)x, (double)y);
        }
        return Math.atan2(x, y);
    }

    public static double sin(double value) {
        if (fast) {
            return FastMath.sin((double)value);
        }
        return Math.sin(value);
    }

    public static double asin(double value) {
        if (fast) {
            return FastMath.asin((double)value);
        }
        return Math.asin(value);
    }

    public static double cos(double value) {
        if (fast) {
            return FastMath.cos((double)value);
        }
        return Math.cos(value);
    }

    public static double acos(double value) {
        if (fast) {
            return FastMath.acos((double)value);
        }
        return Math.acos(value);
    }

    public static double sinh(double value) {
        if (fast) {
            return FastMath.sinh((double)value);
        }
        return Math.sinh(value);
    }

    public static double cosh(double value) {
        if (fast) {
            return FastMath.cosh((double)value);
        }
        return Math.cosh(value);
    }

    public static double sqrt(double value) {
        if (fast) {
            return FastMath.sqrt((double)value);
        }
        return Math.sqrt(value);
    }

    public static double pow(double base, double exponent) {
        if (fast) {
            return FastMath.pow((double)base, (double)exponent);
        }
        return Math.pow(base, exponent);
    }

    public static double exp(double value) {
        if (fast) {
            return FastMath.exp((double)value);
        }
        return Math.exp(value);
    }

    public static double log(double value) {
        if (fast) {
            return FastMath.log((double)value);
        }
        return Math.log(value);
    }

    public static double log10(double value) {
        if (fast) {
            return FastMath.log10((double)value);
        }
        return Math.log10(value);
    }

    public static double signum(double value) {
        if (fast) {
            return FastMath.signum((double)value);
        }
        return Math.signum(value);
    }

    public static double toRadians(double value) {
        if (fast) {
            return FastMath.toRadians((double)value);
        }
        return Math.toRadians(value);
    }

    public static double toDegrees(double value) {
        if (fast) {
            return FastMath.toDegrees((double)value);
        }
        return Math.toDegrees(value);
    }
}

