/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import java.util.Arrays;
import net.anwiba.commons.utilities.math.MathWrapper;

public class Matrix {
    private final double[][] values;
    private final int n;
    private final int m;

    public static Matrix matrix(double[][] values) {
        return new Matrix(values.length, values.length > 0 ? values[0].length : 0, values);
    }

    public Matrix(int n, int m, double[][] values) {
        this.n = n;
        this.m = m;
        this.values = values;
    }

    public int n() {
        return this.n;
    }

    public int m() {
        return this.m;
    }

    public double[][] values() {
        return this.values;
    }

    public Matrix multiply(double value) {
        return Matrix.matrix(Matrix.multiply(this.n, this.m, value, this.values));
    }

    public Matrix multiply(Matrix other) {
        if (other.n != this.m) {
            throw new IllegalArgumentException();
        }
        return Matrix.matrix(Matrix.multiply(this.n, this.m, other.m, this.values, other.values));
    }

    public static double[][] multiply(int n, int m, int p, double[][] matrix, double[][] other) {
        double[][] result = new double[n][p];
        double[] otherVector = new double[m];
        double sum = 0.0;
        int j = 0;
        while (j < p) {
            int k = 0;
            while (k < m) {
                otherVector[k] = other[k][j];
                ++k;
            }
            int i = 0;
            while (i < n) {
                double[] vector = matrix[i];
                sum = 0.0;
                int k2 = 0;
                while (k2 < m) {
                    sum += vector[k2] * otherVector[k2];
                    ++k2;
                }
                result[i][j] = sum;
                ++i;
            }
            ++j;
        }
        return result;
    }

    private void check(Matrix other) {
        if (other.m != this.m || other.n != this.n) {
            throw new IllegalArgumentException();
        }
    }

    public Matrix summate(double value) {
        return Matrix.matrix(Matrix.summate(this.n, this.m, this.values, value));
    }

    public Matrix summate(Matrix other) {
        this.check(other);
        return Matrix.matrix(Matrix.summate(this.n, this.m, this.values, other.values));
    }

    public Matrix subtract(double value) {
        return Matrix.matrix(Matrix.subtract(this.n, this.m, this.values, value));
    }

    public Matrix subtract(Matrix other) {
        this.check(other);
        return Matrix.matrix(Matrix.subtract(this.n, this.m, this.values, other.values));
    }

    public static double[][] copy(int n, int m, double[][] source) {
        double[][] result = new double[n][m];
        Matrix.copy(n, m, source, result);
        return result;
    }

    public static void copy(int n, int m, double[][] source, double[][] target) {
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                target[i][j] = source[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static double[][] identityZ(int n) {
        double[][] result = new double[n][n];
        double d = -1.0 / (double)n;
        double e = 1.0 + d;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                result[i][j] = i != j ? d : e;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] identity(int n) {
        double[][] result = new double[n][n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                result[i][j] = i == j ? 1 : 0;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] transpose(double[][] source) {
        return Matrix.transpose(source.length, source[0].length, source);
    }

    public static double[][] transpose(int n, int m, double[][] source) {
        double[][] result = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                result[i][j] = source[j][i];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] multiply(int n, int m, double scal, double[][] source) {
        double[][] result = new double[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                result[i][j] = scal * source[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] multiply(int n, int m, double[][] matrix, double[] vector) {
        double[] result = new double[n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                int n2 = i;
                result[n2] = result[n2] + matrix[i][j] * vector[j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] summate(int n, int m, double[][] matrix, double[][] other) {
        double[][] result = new double[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                result[i][j] = matrix[i][j] + other[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] summate(int n, int m, double[][] matrix, double value) {
        double[][] result = new double[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                result[i][j] = matrix[i][j] + value;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] subtract(int n, int m, double[][] matrix, double[][] other) {
        double[][] result = new double[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                result[i][j] = matrix[i][j] - other[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] subtract(int n, int m, double[][] matrix, double value) {
        double[][] result = new double[n][m];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                result[i][j] = matrix[i][j] - value;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double trace(int n, int m, double[][] matrix) {
        double result = 0.0;
        int i = 0;
        while (i < MathWrapper.min(n, m)) {
            result += matrix[i][i];
            ++i;
        }
        return result;
    }

    public static void leftHandAccumulation(int m, int n, double[][] p, double[] d) {
        int l = 0;
        double g = 0.0;
        int i = n - 1;
        while (i >= 0) {
            int j;
            l = i + 1;
            g = d[i];
            if (i < n - 1) {
                j = l;
                while (j < n) {
                    p[i][j] = 0.0;
                    ++j;
                }
            }
            if (g != 0.0) {
                g = 1.0 / g;
                if (i != n - 1) {
                    j = l;
                    while (j < n) {
                        double s = 0.0;
                        int k = l;
                        while (k < m) {
                            s += p[k][i] * p[k][j];
                            ++k;
                        }
                        double f = s / p[i][i] * g;
                        int k2 = i;
                        while (k2 < m) {
                            double[] dArray = p[k2];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + f * p[k2][i];
                            ++k2;
                        }
                        ++j;
                    }
                }
                j = i;
                while (j < m) {
                    double[] dArray = p[j];
                    int n3 = i;
                    dArray[n3] = dArray[n3] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < m) {
                    p[j][i] = 0.0;
                    ++j;
                }
            }
            double[] dArray = p[i];
            int n4 = i--;
            dArray[n4] = dArray[n4] + 1.0;
        }
    }

    public static void rightHandAccumulation(int n, double[][] p, double[][] q, double[] r) {
        int l = n;
        double g = 0.0;
        int i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                int j;
                if (g != 0.0) {
                    j = l;
                    while (j < n) {
                        q[j][i] = p[i][j] / p[i][l] / g;
                        ++j;
                    }
                    j = l;
                    while (j < n) {
                        double s = 0.0;
                        int k = l;
                        while (k < n) {
                            s += p[i][k] * q[k][j];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            double[] dArray = q[k];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + s * q[k][i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < n) {
                    q[j][i] = 0.0;
                    q[i][j] = 0.0;
                    ++j;
                }
            }
            q[i][i] = 1.0;
            g = r[i];
            l = i--;
        }
    }

    public static double householderReduction(int m, int n, double[][] p, double[] d, double[] r) {
        double anorm = 0.0;
        int l = 0;
        double g = 0.0;
        double scale = 0.0;
        int i = 0;
        while (i < n) {
            int k;
            int k2;
            int j;
            double h;
            double s = 0.0;
            l = i + 1;
            r[i] = scale * g;
            scale = 0.0;
            g = 0.0;
            if (i < m) {
                int k3 = i;
                while (k3 < m) {
                    scale += MathWrapper.abs(p[k3][i]);
                    ++k3;
                }
                if (scale > 0.0) {
                    k3 = i;
                    while (k3 < m) {
                        double[] dArray = p[k3];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += p[k3][i] * p[k3][i];
                        ++k3;
                    }
                    double f = p[i][i];
                    g = -Matrix.sign(MathWrapper.sqrt(s), f);
                    h = f * g - s;
                    p[i][i] = f - g;
                    if (i != n - 1) {
                        j = l;
                        while (j < n) {
                            s = 0.0;
                            k2 = i;
                            while (k2 < m) {
                                s += p[k2][i] * p[k2][j];
                                ++k2;
                            }
                            f = s / h;
                            k2 = i;
                            while (k2 < m) {
                                double[] dArray = p[k2];
                                int n3 = j;
                                dArray[n3] = dArray[n3] + f * p[k2][i];
                                ++k2;
                            }
                            ++j;
                        }
                    }
                    k = i;
                    while (k < m) {
                        double[] dArray = p[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                        ++k;
                    }
                }
            }
            d[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m && i != n - 1) {
                int k4 = l;
                while (k4 < n) {
                    scale += MathWrapper.abs(p[i][k4]);
                    ++k4;
                }
                if (scale != 0.0) {
                    k4 = l;
                    while (k4 < n) {
                        double[] dArray = p[i];
                        int n5 = k4;
                        dArray[n5] = dArray[n5] / scale;
                        s += p[i][k4] * p[i][k4];
                        ++k4;
                    }
                    double f = p[i][l];
                    g = -Matrix.sign(MathWrapper.sqrt(s), f);
                    h = f * g - s;
                    p[i][l] = f - g;
                    k = l;
                    while (k < n) {
                        r[k] = p[i][k] / h;
                        ++k;
                    }
                    if (i != m - 1) {
                        j = l;
                        while (j < m) {
                            s = 0.0;
                            k2 = l;
                            while (k2 < n) {
                                s += p[j][k2] * p[i][k2];
                                ++k2;
                            }
                            k2 = l;
                            while (k2 < n) {
                                double[] dArray = p[j];
                                int n6 = k2;
                                dArray[n6] = dArray[n6] + s * r[k2];
                                ++k2;
                            }
                            ++j;
                        }
                    }
                    k = l;
                    while (k < n) {
                        double[] dArray = p[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = MathWrapper.max(anorm, MathWrapper.abs(d[i]) + MathWrapper.abs(r[i]));
            ++i;
        }
        return anorm;
    }

    static double radius(double u, double v) {
        double absV;
        double absU = MathWrapper.abs(u);
        if (absU > (absV = MathWrapper.abs(v))) {
            double w = absV / absU;
            return absU * MathWrapper.sqrt(1.0 + w * w);
        }
        if (absV > 0.0) {
            double w = absU / absV;
            return absV * MathWrapper.sqrt(1.0 + w * w);
        }
        return 0.0;
    }

    static double sign(double u, double v) {
        return v >= 0.0 ? MathWrapper.abs(u) : -MathWrapper.abs(u);
    }

    public static void diagonalization(int maxNumberOfIterations, int m, int n, double[][] p, double[] d, double[][] q, double[] r, double anorm) {
        boolean flag = false;
        int nm = 0;
        int l = 0;
        int k = n - 1;
        while (k >= 0) {
            int iteration = 0;
            while (iteration < maxNumberOfIterations) {
                flag = true;
                l = k;
                while (l >= 0) {
                    nm = l - 1;
                    if (MathWrapper.abs(r[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (MathWrapper.abs(d[nm]) + anorm == anorm) break;
                    --l;
                }
                if (flag) {
                    double s = 1.0;
                    int i = l;
                    while (i <= k) {
                        double f = s * r[i];
                        if (MathWrapper.abs(f) + anorm != anorm) {
                            double h;
                            double g = d[i];
                            d[i] = h = Matrix.radius(f, g);
                            h = 1.0 / h;
                            s = -f * h;
                            Matrix.foo(nm, i, m, p, g * h, s);
                        }
                        ++i;
                    }
                }
                if (l == k) {
                    if (!(d[k] < 0.0)) break;
                    d[k] = -d[k];
                    int j = 0;
                    while (j < n) {
                        q[j][k] = -q[j][k];
                        ++j;
                    }
                    break;
                }
                if (iteration == maxNumberOfIterations) {
                    return;
                }
                nm = k - 1;
                Matrix.qrTransformation(l, k, n, m, nm, p, q, d, r);
                ++iteration;
            }
            --k;
        }
    }

    public static void qrTransformation(int l, int k, int n, int m, int k_1, double[][] p, double[][] q, double[] d, double[] r) {
        double x = d[l];
        double r_k = r[k];
        double f = ((d[k_1] - d[k]) * (d[k_1] + d[k]) + (r[k_1] - r_k) * (r[k_1] + r_k)) / (2.0 * r_k * d[k_1]);
        f = ((x - d[k]) * (x + d[k]) + r_k * (d[k_1] / (f + Matrix.sign(Matrix.radius(f, 1.0), f)) - r_k)) / x;
        double c = 1.0;
        double s = 1.0;
        int j = l;
        while (j <= k_1) {
            double z;
            int i = j + 1;
            double y = d[i];
            double h = s * r[i];
            double g = c * r[i];
            r[j] = z = Matrix.radius(f, h);
            c = f / z;
            s = h / z;
            f = x * c + g * s;
            g = g * c - x * s;
            h = y * s;
            y *= c;
            Matrix.foo(j, i, n, q, c, s);
            d[j] = z = Matrix.radius(f, h);
            if (z != 0.0) {
                z = 1.0 / z;
                c = f * z;
                s = h * z;
            }
            f = c * g + s * y;
            x = c * y - s * g;
            Matrix.foo(j, i, m, p, c, s);
            ++j;
        }
        r[l] = 0.0;
        r[k] = f;
        d[k] = x;
    }

    private static void foo(int j, int i, int m, double[][] p, double c, double s) {
        int k = 0;
        while (k < m) {
            double x = p[k][i];
            double y = p[k][j];
            p[k][j] = y * c + x * s;
            p[k][i] = x * c - y * s;
            ++k;
        }
    }

    public static double singularValueDecomposition(int maxNumberOfIterations, int m, int n, double[][] a, double[][] p, double[] d, double[][] q) {
        double[] r = new double[n];
        Matrix.copy(n, n, a, p);
        double anorm = Matrix.householderReduction(m, n, p, d, r);
        Matrix.rightHandAccumulation(n, p, q, r);
        Matrix.leftHandAccumulation(m, n, p, d);
        Matrix.diagonalization(maxNumberOfIterations, m, n, p, d, q, r, anorm);
        return anorm;
    }

    public static double[] oneVector(int m) {
        double[] result = new double[m];
        Arrays.fill(result, 1.0);
        return result;
    }

    public static double[][] fill(double[][] ds) {
        int dim = MathWrapper.max(ds.length, ds[0].length);
        double[][] result = new double[dim][dim];
        int i = 0;
        while (i < ds.length) {
            int j = 0;
            while (j < ds[i].length) {
                result[i][j] = ds[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public double get(int i, int j) {
        return this.values[i][j];
    }
}

