/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.parameter.Parameter;

public final class Parameters
implements IParameters {
    private static final long serialVersionUID = -1L;
    private final List<String> names = new ArrayList<String>();
    private final List<IParameter> parameters = new ArrayList<IParameter>();
    private final Map<String, IParameter> map = new HashMap<String, IParameter>();

    public Parameters(List<IParameter> parameters) {
        this.parameters.addAll(parameters);
        for (IParameter parameter : parameters) {
            this.names.add(parameter.getName());
            this.map.put(parameter.getName(), parameter);
        }
    }

    @Override
    public int getNumberOfParameter() {
        return this.parameters.size();
    }

    @Override
    public IParameter getParameter(int index) {
        return this.parameters.get(index);
    }

    @Override
    public IParameters adapt(int index, IParameter parameter) {
        IParameter[] array = this.parameters.toArray(new IParameter[this.parameters.size()]);
        array[index] = parameter;
        return new Parameters(Arrays.asList(array));
    }

    @Override
    public Iterable<IParameter> parameters() {
        return this.parameters;
    }

    @Override
    public IParameters toLowerCase() {
        return new Parameters(this.parameters.stream().map(p -> new Parameter(p.getName(), p.getValue())).collect(Collectors.toList()));
    }

    @Override
    public Iterable<String> getNames() {
        return this.names;
    }

    @Override
    public String getValue(String name) throws RuntimeException {
        if (!this.map.containsKey(name)) {
            return null;
        }
        return this.map.get(name).getValue();
    }

    @Override
    public boolean containts(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public void forEach(Consumer<IParameter> consumer) {
        this.parameters.forEach(consumer);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameters other = (Parameters)obj;
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        if (this.names == null ? other.names != null : !this.names.equals(other.names)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }
}

