/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.program;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.utilities.OperationSystemUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

public class ProgramLauncher {
    private static ILogger logger = Logging.getLogger((String)ProgramLauncher.class.getName());
    private IConsumer<InputStream, RuntimeException> inputStreamConsumer = null;
    private IConsumer<InputStream, RuntimeException> errorStreamConsumer = null;
    private boolean isWaitFor = false;
    private String command = null;
    private final List<String> arguments = new ArrayList<String>();

    public ProgramLauncher waitNot() {
        this.isWaitFor = false;
        return this;
    }

    public ProgramLauncher waitFor() {
        this.isWaitFor = true;
        return this;
    }

    public ProgramLauncher streamToLogger() {
        this.inputStreamConsumer(this.createStreamConsumer(ILevel.DEBUG));
        this.errorStreamConsumer(this.createStreamConsumer(ILevel.ERROR));
        return this;
    }

    private IConsumer<InputStream, RuntimeException> createStreamConsumer(final Level level) {
        return new IConsumer<InputStream, RuntimeException>(){

            public void consume(InputStream input) throws RuntimeException {
                StringBuffer buffer = new StringBuffer();
                try {
                    try {
                        int value = 0;
                        while ((value = input.read()) > 0) {
                            switch (value) {
                                case 10: {
                                    logger.log(level, buffer.toString());
                                    buffer = new StringBuffer();
                                    break;
                                }
                                default: {
                                    buffer.append((char)value);
                                }
                            }
                        }
                        logger.log(level, buffer.toString());
                    }
                    catch (IOException exception) {
                        logger.log(level, buffer.toString());
                        logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
                        IoUtilities.close((Closeable)input);
                    }
                }
                finally {
                    IoUtilities.close((Closeable)input);
                }
            }
        };
    }

    public ProgramLauncher command(String command) {
        this.command = command;
        return this;
    }

    public ProgramLauncher argument(String argument) {
        this.arguments.add(argument);
        return this;
    }

    public ProgramLauncher errorStreamConsumer(IConsumer<InputStream, RuntimeException> errorStreamConsumer) {
        if (errorStreamConsumer == null) {
            return this;
        }
        this.errorStreamConsumer = errorStreamConsumer;
        return this;
    }

    public ProgramLauncher inputStreamConsumer(IConsumer<InputStream, RuntimeException> inputStreamConsumer) {
        if (inputStreamConsumer == null) {
            return this;
        }
        this.inputStreamConsumer = inputStreamConsumer;
        return this;
    }

    public void launch() {
        try {
            ArrayList<String> command = new ArrayList<String>();
            if (OperationSystemUtilities.isLinux() || OperationSystemUtilities.isBSD() || OperationSystemUtilities.isUnix()) {
                command.add("sh");
                command.add("-c");
            } else if (OperationSystemUtilities.isWindows()) {
                command.add("cmd");
                command.add("/c");
            }
            String commandString = this.create(this.command, this.arguments);
            Optional.of((Object)commandString).consume(c -> {
                boolean bl = command.add((String)c);
            });
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Optional.of(this.inputStreamConsumer).consume(consumer -> {
                ProcessBuilder processBuilder2 = processBuilder.redirectError(ProcessBuilder.Redirect.PIPE);
            });
            Optional.of(this.errorStreamConsumer).consume(consumer -> {
                ProcessBuilder processBuilder2 = processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE);
            });
            Process process = processBuilder.start();
            Optional.of(this.inputStreamConsumer).consume(consumer -> consumer.consume((Object)process.getInputStream()));
            Optional.of(this.errorStreamConsumer).consume(consumer -> consumer.consume((Object)process.getErrorStream()));
            if (this.isWaitFor) {
                process.waitFor();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
        }
    }

    private String create(String command, List<String> arguments) {
        if (StringUtilities.isNullOrEmpty(command) && arguments.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Optional.of((Object)command).consume(c -> {
            builder.append((String)c);
            builder.append(" ");
        });
        boolean flag = false;
        for (String argument : arguments) {
            if (flag) {
                builder.append(" ");
            }
            builder.append(argument);
            flag = true;
        }
        return builder.toString();
    }
}

