/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import net.anwiba.commons.utilities.math.MathWrapper;

public final class Angle {
    public static final double TWO_PI = Math.PI * 2;
    public static final double RHO_DEGREE = 57.29577951308232;
    public static final double RHO_GON = 63.66197723675813;
    public static final double RHO_SEMI_CIRCLE = 0.3183098861837907;
    private double value;

    public Angle() {
        this.value = 0.0;
    }

    private Angle(double value) {
        this.value = value;
    }

    public static Angle radian(double x) {
        return new Angle(x % (Math.PI * 2));
    }

    public static Angle gon(double value) {
        return new Angle(value / 63.66197723675813 % (Math.PI * 2));
    }

    public static Angle degree(double value) {
        return new Angle(value / 57.29577951308232 % (Math.PI * 2));
    }

    public static Angle semiCircle(double value) {
        return new Angle(value / 0.3183098861837907 % (Math.PI * 2));
    }

    public static Angle degree(int degree, int minute, double second) {
        return Angle.degree((double)degree + (double)minute / 60.0 + second / 3600.0);
    }

    public double radian() {
        return this.value;
    }

    public double degree() {
        return this.radian() * 57.29577951308232;
    }

    public double gon() {
        return this.radian() * 63.66197723675813;
    }

    public double arcSeconds() {
        return this.degree() * 3600.0;
    }

    public double semiCircle() {
        return this.radian() * 0.3183098861837907;
    }

    public Angle add(Angle angle) {
        this.value += angle.radian();
        this.value %= Math.PI * 2;
        return this;
    }

    public Angle subtract(Angle angle) {
        this.value -= angle.radian();
        this.value %= Math.PI * 2;
        return this;
    }

    public static double sin(Angle value) {
        return MathWrapper.sin(value.radian());
    }

    public static double cos(Angle value) {
        return MathWrapper.cos(value.radian());
    }
}

