/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import net.anwiba.commons.utilities.time.TimeZoneUtilities;

public class ZonedDateTimeUtilities {
    public static ZonedDateTime atTimeZone(java.sql.Date date, ZoneId zone) {
        return ZonedDateTimeUtilities.atTimeZone(new Date(date.getTime()), zone);
    }

    public static ZonedDateTime atTimeZone(Date date, ZoneId zone) {
        return ZonedDateTime.ofInstant(date.toInstant(), zone);
    }

    public static ZonedDateTime atCoordinatedUniversalTimeZone(Date value) {
        return ZonedDateTimeUtilities.atTimeZone(value, ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }

    public static ZonedDateTime atCoordinatedUniversalTimeZone(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId).toInstant().atZone(ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }

    public static ZonedDateTime atCoordinatedUniversalTimeZone(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().atZone(ZonedDateTimeUtilities.getCoordinatedUniversalTimeZone());
    }

    public static ZoneId getUserZone() {
        return TimeZoneUtilities.getUserTimeZone().toZoneId();
    }

    public static ZoneId getSystemZone() {
        return TimeZoneUtilities.getSystemTimeZone().toZoneId();
    }

    public static ZoneId getCoordinatedUniversalTimeZone() {
        return ZoneId.of("UTC");
    }

    public static String toString(ZonedDateTime dateTime) {
        return dateTime.format(DateTimeFormatter.ISO_INSTANT);
    }
}

