/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.property.IProperty;

public final class Properties
implements IProperties {
    private static final long serialVersionUID = 655956184779585973L;
    private final List<String> names = new ArrayList<String>();
    private final List<IProperty> parameters = new ArrayList<IProperty>();
    private final Map<String, IProperty> map = new HashMap<String, IProperty>();

    public Properties(List<IProperty> parameters) {
        this.parameters.addAll(parameters);
        for (IProperty parameter : parameters) {
            this.names.add(parameter.getName());
            this.map.put(parameter.getName(), parameter);
        }
    }

    @Override
    public int getNumberOfProperties() {
        return this.parameters.size();
    }

    @Override
    public IProperty getProperty(int index) {
        return this.parameters.get(index);
    }

    @Override
    public IProperties adapt(int index, IProperty parameter) {
        IProperty[] array = this.parameters.toArray(new IProperty[this.parameters.size()]);
        array[index] = parameter;
        return new Properties(Arrays.asList(array));
    }

    @Override
    public Iterable<IProperty> properties() {
        return this.parameters;
    }

    @Override
    public Iterable<String> getNames() {
        return this.names;
    }

    @Override
    public String getValue(String name) throws RuntimeException {
        if (!this.map.containsKey(name)) {
            return null;
        }
        return this.map.get(name).getValue();
    }

    @Override
    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        if (this.names == null ? other.names != null : !this.names.equals(other.names)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }
}

