/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class DateTimeInterval {
    private static ILogger logger = Logging.getLogger(DateTimeInterval.class);
    private final ZonedDateTime from;
    private final ZonedDateTime until;
    private final Duration resolution;

    public DateTimeInterval(ZonedDateTime from, ZonedDateTime until, Duration resolution) {
        this.from = from;
        this.until = until;
        this.resolution = resolution;
    }

    public ZonedDateTime getFrom() {
        return this.from;
    }

    public ZonedDateTime getUntil() {
        return this.until;
    }

    public Duration getDuration() {
        return Duration.between(this.from, this.until);
    }

    public Duration getResolution() {
        return this.resolution;
    }

    public boolean contains(ZonedDateTime value) {
        return !this.from.isAfter(value) && !this.until.isBefore(value);
    }

    public String toString() {
        return String.valueOf(this.from.toString()) + "/" + this.until.toString() + "/" + this.resolution.toString();
    }

    public static DateTimeInterval valueOf(String range) {
        try {
            Matcher matcher = Pattern.compile("(.+)/(.+)/(.+)").matcher(range);
            if (matcher.matches() && matcher.groupCount() == 3) {
                ZonedDateTime from = ZonedDateTime.parse(matcher.group(1));
                ZonedDateTime until = ZonedDateTime.parse(matcher.group(2));
                Duration resolution = Duration.parse(matcher.group(3));
                return new DateTimeInterval(from, until, resolution);
            }
            return null;
        }
        catch (DateTimeException exception) {
            logger.log(ILevel.DEBUG, exception.getMessage(), (Throwable)exception);
            return null;
        }
    }
}

