/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.ArrayUtilities;

public class IterableUtilities {
    public static <T> Set<T> asSet(Iterable<T> iterable) {
        HashSet<T> result = new HashSet<T>();
        for (T item : iterable) {
            result.add(item);
        }
        return result;
    }

    public static <T> Set<T> asSet(Iterable<T> iterable, IAcceptor<T> validator) {
        HashSet<T> result = new HashSet<T>();
        for (T item : iterable) {
            if (!validator.accept(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <T> Iterable<T> reverse(Iterable<T> iterable) {
        List<T> list = IterableUtilities.asList(iterable);
        Collections.reverse(list);
        return list;
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> clazz) {
        List<Object> list = IterableUtilities.asList(iterable);
        Object[] array = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(array);
    }

    public static int[] toPrimativArray(Iterable<Integer> iterable) {
        List<Integer> list = IterableUtilities.asList(iterable);
        Integer[] dummy = (Integer[])Array.newInstance(Integer.class, list.size());
        Integer[] array = list.toArray(dummy);
        return ArrayUtilities.primitives(array);
    }

    public static <T> List<T> asList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : iterable) {
            result.add(item);
        }
        return result;
    }

    public static <T> List<T> asList(Iterable<T> iterable, IAcceptor<T> validator) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : iterable) {
            if (!validator.accept(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <T> boolean containsAcceptedItems(Iterable<T> values, IAcceptor<T> validator) {
        for (T value : values) {
            if (!validator.accept(value)) continue;
            return true;
        }
        return false;
    }

    public static <I, O, E extends Exception> Iterable<O> convert(Iterable<I> values, IConverter<I, O, E> converter) throws E {
        ArrayList<Object> result = new ArrayList<Object>();
        for (I value : values) {
            result.add(converter.convert(value));
        }
        return result;
    }

    public static <I> Iterable<I> concat(Iterable<I> ... values) {
        ArrayList<I> result = new ArrayList<I>();
        Iterable<I>[] iterableArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Iterable<I> value = iterableArray[n2];
            for (I item : value) {
                result.add(item);
            }
            ++n2;
        }
        return result;
    }

    public static <I> Iterable<I> normalize(Iterable<I> values) {
        ArrayList<I> result = new ArrayList<I>();
        for (I item : values) {
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    public static <T> String toString(Iterable<T> iterable, String seperator) {
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (T parameter : iterable) {
            if (flag) {
                builder.append(seperator);
            }
            builder.append(parameter);
            flag = true;
        }
        return builder.toString();
    }
}

