/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.queue;

public class IntValueQueue {
    private Node first = null;
    private Node last = null;

    public synchronized boolean isEmpty() {
        return this.first == null;
    }

    public synchronized void clear() {
        this.first = null;
        this.last = null;
    }

    public synchronized int poll() {
        int value = this.first.getValue();
        this.first = this.first.getSuccessor();
        if (this.first == null) {
            this.last = null;
        }
        return value;
    }

    public synchronized void add(int value) {
        if (this.first == null) {
            this.first = this.last = new Node(value);
            return;
        }
        this.last.setSuccessor(new Node(value));
        this.last = this.last.getSuccessor();
    }

    static class Node {
        private Node successor = null;
        private final int value;

        public Node(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setSuccessor(Node successor) {
            this.successor = successor;
        }

        public Node getSuccessor() {
            return this.successor;
        }
    }
}

