/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.interval;

import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.interval.IObjectInterval;

public class ObjectInterval<T extends Comparable<T>>
implements IObjectInterval<T> {
    private final T startValue;
    private final T endValue;

    public ObjectInterval(T startValue, T endValue) {
        this.startValue = startValue;
        this.endValue = endValue;
    }

    @Override
    public boolean inside(T value) {
        return value.compareTo(this.startValue) > 0 && value.compareTo(this.endValue) < 0;
    }

    @Override
    public boolean interact(T value) {
        return value.compareTo(this.startValue) == 0 || value.compareTo(this.endValue) == 0 || this.inside(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectInterval)) {
            return false;
        }
        ObjectInterval other = (ObjectInterval)obj;
        return ObjectUtilities.equals((Object[])new Object[]{this.startValue, this.endValue}, (Object[])new Object[]{other.startValue, other.endValue});
    }

    public int hashCode() {
        return ObjectUtilities.hashCode((Object[])new Object[]{this.startValue, this.endValue});
    }
}

