/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.property;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class PropertyUtilities {
    private static ILogger logger = Logging.getLogger((String)"PropertyUtilities.class");

    public static Properties getProperties(String propertiesFile) {
        Properties properties = new Properties(System.getProperties());
        if (propertiesFile != null) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream inputstream = new FileInputStream(propertiesFile);){
                    properties.load(inputstream);
                    ((InputStream)inputstream).close();
                    System.setProperties(properties);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.log(ILevel.WARNING, String.valueOf(propertiesFile) + " ist nicht vorhanden");
                return null;
            }
            catch (IOException iOException) {
                logger.log(ILevel.WARNING, String.valueOf(propertiesFile) + " konnte nicht geladen werden");
                return null;
            }
        }
        return properties;
    }
}

