/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.interval;

import java.util.Arrays;
import java.util.Iterator;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.interval.IntegerIterator;

public class IntegerInterval
implements Iterable<Integer> {
    private final int minValue;
    private final int maxValue;

    public IntegerInterval(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public boolean inside(int value) {
        return value > Math.min(this.minValue, this.maxValue) && Math.max(this.minValue, this.maxValue) > value;
    }

    public boolean interact(int value) {
        return value == this.minValue || value == this.maxValue || this.inside(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntegerInterval)) {
            return false;
        }
        IntegerInterval other = (IntegerInterval)obj;
        return Arrays.equals(new int[]{this.minValue, this.maxValue}, new int[]{other.minValue, other.maxValue});
    }

    public int hashCode() {
        return ObjectUtilities.hashCode((Object[])new Object[]{(double)this.minValue, (double)this.maxValue});
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntegerIterator(this.minValue, this.maxValue);
    }
}

