/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.name;

import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.string.StringUtilities;
import org.apache.commons.lang.CharSet;

public class LowerCaseNameConverter
implements IConverter<String, String, RuntimeException> {
    private static final String N = "n";
    ISupplier<String, String> prefixSupplier = new ISupplier<String, String>(){

        @Override
        public String supply(String input) {
            return LowerCaseNameConverter.N;
        }
    };

    public String convert(String input) {
        if (StringUtilities.isNullOrTrimmedEmpty(input)) {
            return N;
        }
        StringBuilder builder = new StringBuilder();
        boolean whitespaceFlag = false;
        int i = 0;
        while (i < input.length()) {
            char c = this.substitute(input.charAt(i));
            if ('_' == c) {
                whitespaceFlag = true;
            } else {
                if (builder.length() == 0 && CharSet.ASCII_NUMERIC.contains(c)) {
                    builder.append(this.prefixSupplier.supply(input));
                }
                if (builder.length() > 0 && whitespaceFlag) {
                    builder.append('_');
                }
                whitespaceFlag = false;
                builder.append(c);
            }
            ++i;
        }
        String string = builder.toString();
        return StringUtilities.isNullOrTrimmedEmpty(string) ? N : string;
    }

    private char substitute(char c) {
        if (CharSet.ASCII_NUMERIC.contains(c)) {
            return c;
        }
        if (CharSet.ASCII_ALPHA.contains(c)) {
            return Character.toLowerCase(c);
        }
        return '_';
    }

    static interface ISupplier<I, O> {
        public O supply(I var1);
    }
}

