/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.number;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.utilities.number.LongValueBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;

public class RobustDoubleParser {
    private static final String INFINITY = "infinity";
    private final int MIN = 48;
    private final int MAX = 57;

    public double parse(String string) {
        if (this.isInfinity(string)) {
            return this.extractInfinity(string);
        }
        if (this.isNaN(string)) {
            return Double.NaN;
        }
        char[] chars = string.toCharArray();
        ArrayList<LongValueBuilder> longValueBuilders = new ArrayList<LongValueBuilder>(20);
        ArrayList<Character> separators = new ArrayList<Character>(20);
        LongValueBuilder longValueBuilder = new LongValueBuilder(string);
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (this.isNegativeSign(c)) {
                longValueBuilder.setNegativ();
            } else if (this.isDigit(c)) {
                longValueBuilder.add(c);
            } else if (c != '+') {
                if (c == ',' || c == '.' || c == 'E' || c == 'e') {
                    longValueBuilders.add(longValueBuilder);
                    separators.add(Character.valueOf(c));
                    longValueBuilder = new LongValueBuilder(string);
                } else {
                    this.throwException(string);
                }
            }
            ++i;
        }
        longValueBuilders.add(longValueBuilder);
        SeparatorConfiguration separatorConfiguration = this.analyseSeparators(separators, string);
        long preSeparatorValue = this.extractPreSeparatorValue(longValueBuilders, separatorConfiguration.preSeparatorBlockCount);
        double postSeparatorValue = this.extractPostSeparatorValue(longValueBuilders, separatorConfiguration.postSeparatorBlockIndex);
        long exponentValue = this.extractExponentValue(longValueBuilders, separatorConfiguration.exponentSeparatorBlockIndex);
        double value = ((double)preSeparatorValue + postSeparatorValue) * Math.pow(10.0, exponentValue);
        if (this.isNegative(longValueBuilders)) {
            value *= -1.0;
        }
        return value;
    }

    private boolean isNaN(String string) {
        return string.matches("-?(\\?|[Nn][Aa][Nn])");
    }

    private boolean isInfinity(String string) {
        return StringUtilities.containsIgnoreCase(string, INFINITY);
    }

    private double extractInfinity(String string) {
        int minusCount = StringUtilities.numberOfMatches(string, "-");
        return this.isEven(minusCount) ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
    }

    private boolean isEven(int minuses) {
        return minuses % 2 == 0;
    }

    private void throwException(String originalString) {
        throw new NumberFormatException(MessageFormat.format("Unable to parse string ''{0}'' as Double.", originalString));
    }

    private SeparatorConfiguration analyseSeparators(List<Character> separators, String originalString) {
        Character lastSepataror = null;
        boolean exponentSeparatorFound = false;
        boolean separatorFound = false;
        boolean secondSeparatorFound = false;
        int separatorsCount = separators.size();
        int i = 0;
        while (i < separatorsCount) {
            Character separator = separators.get(i);
            char separatorValue = separator.charValue();
            if (separatorValue == '.' || separatorValue == ',') {
                if (exponentSeparatorFound) {
                    this.throwException(originalString);
                }
                separatorFound = true;
                if (lastSepataror != null && separatorValue != lastSepataror.charValue()) {
                    if (secondSeparatorFound) {
                        this.throwException(originalString);
                    }
                    secondSeparatorFound = true;
                }
            } else if (separatorValue == 'E' || separatorValue == 'e') {
                exponentSeparatorFound = true;
            }
            lastSepataror = separator;
            ++i;
        }
        SeparatorConfiguration separatorConfiguration = new SeparatorConfiguration();
        int preSeparatorBlockCount = separatorsCount + 1;
        int postSeparatorBlockIndex = -1;
        int exponentSeparatorBlockIndex = -1;
        if (separatorFound) {
            --preSeparatorBlockCount;
            postSeparatorBlockIndex = separatorsCount;
        }
        if (exponentSeparatorFound) {
            --preSeparatorBlockCount;
            --postSeparatorBlockIndex;
            exponentSeparatorBlockIndex = separatorsCount;
        }
        separatorConfiguration.preSeparatorBlockCount = preSeparatorBlockCount;
        separatorConfiguration.postSeparatorBlockIndex = postSeparatorBlockIndex;
        separatorConfiguration.exponentSeparatorBlockIndex = exponentSeparatorBlockIndex;
        return separatorConfiguration;
    }

    private boolean isNegative(List<LongValueBuilder> longValueBuilders) {
        return longValueBuilders.get(0).isNegativ();
    }

    private long extractExponentValue(List<LongValueBuilder> longValueBuilders, int exponentSeparatorBlockIndex) {
        if (exponentSeparatorBlockIndex < 0) {
            return 0L;
        }
        LongValueBuilder longValueBuilder = longValueBuilders.get(exponentSeparatorBlockIndex);
        long parsedLongValue = longValueBuilder.build();
        if (!longValueBuilder.isNegativ()) {
            return parsedLongValue;
        }
        return parsedLongValue * -1L;
    }

    private double extractPostSeparatorValue(List<LongValueBuilder> longValueBuilders, int valueString) {
        if (valueString < 0) {
            return 0.0;
        }
        LongValueBuilder longValueBuilder = longValueBuilders.get(valueString);
        long postSeparatorNumber = longValueBuilder.build();
        int length = longValueBuilder.length();
        return (double)postSeparatorNumber / Math.pow(10.0, length);
    }

    private long extractPreSeparatorValue(List<LongValueBuilder> longValueBuilders, int preSeparatorBlockCount) {
        long amount = 0L;
        int i = 0;
        while (i < preSeparatorBlockCount) {
            double factor = Math.pow(1000.0, preSeparatorBlockCount - i - 1);
            long longValue = longValueBuilders.get(i).build();
            amount = (long)((double)amount + Math.abs((double)longValue * factor));
            ++i;
        }
        return amount;
    }

    private boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private boolean isNegativeSign(int c) {
        return c == 45;
    }

    private class SeparatorConfiguration {
        public int preSeparatorBlockCount;
        public int postSeparatorBlockIndex;
        public int exponentSeparatorBlockIndex;

        private SeparatorConfiguration() {
        }
    }
}

