/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteUtilities {
    public static int getIntegerLittleEndian(byte[] destination, int pos) {
        return ByteUtilities.getInteger(destination, pos, ByteOrder.LITTLE_ENDIAN);
    }

    public static int getIntegerBigEndian(byte[] destination, int pos) {
        return ByteUtilities.getInteger(destination, pos, ByteOrder.BIG_ENDIAN);
    }

    public static int getInteger(byte[] destination, int pos, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(destination, pos, 4);
        buffer.order(byteOrder);
        return buffer.getInt(pos);
    }

    public static short getShortLittleEndian(byte[] destination, int pos) {
        return ByteUtilities.getShort(destination, pos, ByteOrder.LITTLE_ENDIAN);
    }

    public static short getShort(byte[] destination, int pos, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(destination, pos, 2);
        buffer.order(byteOrder);
        return buffer.getShort(pos);
    }

    public static int setIntegerLittleEndian(int value, byte[] destination, int pos) {
        return ByteUtilities.setInteger(value, destination, pos, ByteOrder.LITTLE_ENDIAN);
    }

    public static int setIntegerBigEndian(int value, byte[] destination, int pos) {
        return ByteUtilities.setInteger(value, destination, pos, ByteOrder.BIG_ENDIAN);
    }

    public static int setInteger(int value, byte[] destination, int pos, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(destination);
        buffer.order(byteOrder);
        buffer.putInt(pos, value);
        return pos + 4;
    }

    public static double getDoubleBigEndian(byte[] destination, int pos) {
        return ByteUtilities.getDouble(destination, pos, ByteOrder.BIG_ENDIAN);
    }

    public static double getDoubleLittleEndian(byte[] destination, int pos) {
        return ByteUtilities.getDouble(destination, pos, ByteOrder.LITTLE_ENDIAN);
    }

    public static double getDouble(byte[] destination, int pos, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(destination, pos, 8);
        buffer.order(byteOrder);
        return buffer.getDouble(pos);
    }

    public static int setDoubleBigEndian(double value, byte[] destination, int pos) {
        return ByteUtilities.setDouble(value, destination, pos, ByteOrder.BIG_ENDIAN);
    }

    public static int setDoubleLittleEndian(double value, byte[] destination, int pos) {
        return ByteUtilities.setDouble(value, destination, pos, ByteOrder.LITTLE_ENDIAN);
    }

    public static int setDouble(double value, byte[] destination, int pos, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(destination);
        buffer.order(byteOrder);
        buffer.putDouble(pos, value);
        return pos + 8;
    }

    public static float getFloatBigEndian(byte[] destination, int pos) {
        return ByteUtilities.getFloat(destination, pos, ByteOrder.BIG_ENDIAN);
    }

    public static float getFloatLittleEndian(byte[] destination, int pos) {
        return ByteUtilities.getFloat(destination, pos, ByteOrder.LITTLE_ENDIAN);
    }

    public static float getFloat(byte[] destination, int pos, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(destination, pos, 4);
        buffer.order(byteOrder);
        return buffer.getFloat(pos);
    }

    public static int setFloatBigEndian(float value, byte[] destination, int pos) {
        return ByteUtilities.setDouble(value, destination, pos, ByteOrder.BIG_ENDIAN);
    }

    public static int setFloatLittleEndian(float value, byte[] destination, int pos) {
        return ByteUtilities.setDouble(value, destination, pos, ByteOrder.LITTLE_ENDIAN);
    }

    public static int setFloat(float value, byte[] destination, int pos, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(destination);
        buffer.order(byteOrder);
        buffer.putFloat(pos, value);
        return pos + 4;
    }
}

