/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.cache;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.reference.IResourceReference;
import net.anwiba.commons.reference.IResourceReferenceFactory;
import net.anwiba.commons.reference.IResourceReferenceHandler;
import net.anwiba.commons.utilities.cache.CacheObject;
import net.anwiba.commons.utilities.cache.ICache;
import net.anwiba.commons.utilities.cache.ICacheObject;

public class WeakInMemoryCache
implements ICache {
    private final Map<Object, List<ICacheObject>> objects = new ConcurrentHashMap<Object, List<ICacheObject>>();
    private final long lifeTime;
    private final IResourceReferenceHandler resourceReferenceHandler;
    private final IResourceReferenceFactory resourceReferenceFactory;

    public WeakInMemoryCache(IResourceReferenceFactory resourceReferenceFactory, IResourceReferenceHandler resourceReferenceHandler, long lifeTime) {
        this.resourceReferenceFactory = resourceReferenceFactory;
        this.resourceReferenceHandler = resourceReferenceHandler;
        this.lifeTime = lifeTime;
    }

    @Override
    public IResourceReference add(Object key, byte[] data, String mimeType, String encoding) {
        return this.add(key, data, mimeType, encoding, this.lifeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResourceReference add(Object key, byte[] data, String mimeType, String encoding, long lifeTime) {
        IResourceReference resourceReference = this.resourceReferenceFactory.create(data, mimeType, encoding);
        if (data == null || data.length == 0) {
            return resourceReference;
        }
        if (mimeType == null || mimeType.isBlank()) {
            return resourceReference;
        }
        Map<Object, List<ICacheObject>> map = this.objects;
        synchronized (map) {
            this.objects.putIfAbsent(key, new LinkedList());
            this.objects.get(key).add(new CacheObject(key, lifeTime, resourceReference));
            return resourceReference;
        }
    }

    @Override
    public IOptional<IResourceReference, RuntimeException> getResourceReference(Object key) {
        List<IResourceReference> references = this.getResourceReferences(key);
        if (references.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Object)references.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IResourceReference> getResourceReferences(Object key) {
        Map<Object, List<ICacheObject>> map = this.objects;
        synchronized (map) {
            try {
                List<ICacheObject> list = this.objects.get(key);
                if (list == null || list.isEmpty()) {
                    return List.of();
                }
                LinkedList<IResourceReference> references = new LinkedList<IResourceReference>();
                for (ICacheObject object : list) {
                    IResourceReference resourceReference = object.getResourceReference();
                    if (resourceReference == null) {
                        this.objects.remove(key);
                        return List.of();
                    }
                    try {
                        long lastModified = this.resourceReferenceHandler.lastModified(resourceReference);
                        long currentTimeMillis = System.currentTimeMillis();
                        long age = currentTimeMillis - lastModified;
                        long objectLifeTime = object.getLifeTime();
                        if (age > objectLifeTime) {
                            this.objects.remove(key);
                            return List.of();
                        }
                        references.add(resourceReference);
                    }
                    catch (IOException e) {
                        this.objects.remove(key);
                        return List.of();
                    }
                }
                return references;
            }
            catch (NullPointerException exception) {
                this.objects.remove(key);
                return List.of();
            }
        }
    }

    @Override
    public void clear() {
        this.objects.clear();
    }
}

