/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.color;

import java.awt.Color;
import java.util.ArrayList;

public final class ColorUtilities {
    public static Color create(Color minColor, Color maxColor, double value) {
        try {
            return new Color(ColorUtilities.getColorPart(minColor.getRed(), maxColor.getRed(), value), ColorUtilities.getColorPart(minColor.getGreen(), maxColor.getGreen(), value), ColorUtilities.getColorPart(minColor.getBlue(), maxColor.getBlue(), value), ColorUtilities.getColorPart(minColor.getAlpha(), maxColor.getAlpha(), value));
        }
        catch (Exception exception) {
            return Color.RED;
        }
    }

    private static int getColorPart(int min, int max, double value) {
        long round = Math.round((double)min + (double)(max - min) * value);
        return (int)round;
    }

    public static Color[] create(Color minColor, Color maxColor, int size) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < size; ++i) {
            double value = (double)i / (double)size;
            colors.add(ColorUtilities.create(minColor, maxColor, value));
        }
        return colors.toArray(new Color[colors.size()]);
    }
}

