/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io;

import net.anwiba.commons.utilities.io.IEncodingType;

public enum EncodingType implements IEncodingType
{
    IBM_437(1, "IBM437", "Cp437"),
    IBM_850(2, "IBM850", "Cp850"),
    WINDOWS_1252(3, "windows-1252", "Cp1252"),
    DANISH(8, "IBM865", "Cp865"),
    IBM_775(9, "IBM775", "Cp775"),
    DUTCH(10, "IBM850", "Cp850"),
    FINNISH_LEAGACY(11, "IBM437", "Cp437"),
    FRENCH_LEAGACY(13, "IBM437", "Cp437"),
    FRENCH(14, "IBM850", "Cp850"),
    GERMAN_LEAGACY(15, "IBM437", "Cp437"),
    GERMAN(16, "IBM850", "Cp850"),
    ITALIAN_LEAGACY(17, "IBM437", "Cp437"),
    ITALIAN(18, "IBM850", "Cp850"),
    JAPANESE_SHIFT_JIS(19, "IBM932", "Cp932"),
    SPANISH(20, "IBM850", "Cp850"),
    SWEDISH_LEAGACY(21, "IBM437", "Cp437"),
    SWEDISH(22, "IBM850", "Cp850"),
    NORWEGIAN(23, "IBM865", "Cp865"),
    SPANISH_LEAGACY(24, "IBM437", "Cp437"),
    ENGLISH_LEAGACY_BRITAIN(25, "IBM437", "Cp437"),
    ENGLISH_BRITAIN(26, "IBM850", "Cp850"),
    ENGLISH_LEAGACY_US(27, "IBM437", "Cp437"),
    FRENCH_CANADA(28, "IBM863", "Cp863"),
    FRENCH_X(29, "IBM850", "Cp850"),
    CZECH(31, "IBM852", "Cp852"),
    HUNGARIAN(34, "IBM852", "Cp852"),
    POLISH(35, "IBM852", "Cp852"),
    PORTUGESE(36, "IBM860", "Cp860"),
    PORTUGESE_LEAGACY(37, "IBM850", "Cp850"),
    RUSSIAN(38, "IBM866", "Cp866"),
    ENGLISH_US(55, "IBM850", "Cp850"),
    ROMANIAN(64, "IBM852", "Cp852"),
    CHINESE_GBK_PRC(77, "IBM936", "Cp936"),
    KOREAN_ANSI(78, "IBM949", "Cp949"),
    CHINESE_BIG_5_TAIWAN(79, "IBM950", "Cp950"),
    THAI_ANSI(80, "x-IBM874", "Cp874"),
    ANSI(87, "windows-1252", "Cp1252"),
    WESTERN_EUROPEAN_ANSI(88, "windows-1252", "Cp1252"),
    SPANISH_ANSI(89, "windows-1252", "Cp1252"),
    IBM_852(100, "IBM852", "Cp852"),
    IBM_865(101, "IBM865", "Cp865"),
    IBM_866(102, "IBM866", "Cp866"),
    IBM_861(103, "IBM861", "Cp861"),
    IBM_737(106, "x-IBM737", "Cp737"),
    IBM_857(107, "IBM857", "Cp857"),
    IBM_863(108, "IBM863", "Cp863"),
    TAIWAN_BIG_5(120, "IBM950", "Cp950"),
    HANGUL_WANSUNG(121, "IBM949", "Cp949"),
    PRC_GBK(122, "IBM936", "Cp936"),
    X_JAPANESE_SHIFT_JIS(123, "IBM932", "Cp932"),
    THAI_WINDOWS_MS_DOS(124, "IBM874", "Cp874"),
    GREEK(-122, "IBM737", "Cp737"),
    SLOVENIAN(-121, "IBM852", "Cp852"),
    TURKISH(-120, "IBM857", "Cp857"),
    WINDOWS_1250(-56, "windows-1250", "Cp1250"),
    WINDOWS_1251(-55, "windows-1251", "Cp1251"),
    WINDOWS_1253(-53, "windows-1253", "Cp1253"),
    WINDOWS_1254(-54, "windows-1254", "Cp1254"),
    WINDOWS_1257(-52, "windows-1257", "Cp1257"),
    UTF_8(0, "UTF-8", "UTF8"),
    IBM_858(0, "IBM00858", "Cp858"),
    IBM_855(0, "IBM855", "Cp855"),
    IBM_862(0, "IBM862", "Cp862"),
    ISO_8859_1(0, "ISO-8859-1", "ISO8859_1"),
    ISO_8859_2(0, "ISO-8859-2", "ISO8859_2"),
    ISO_8859_4(0, "ISO-8859-4", "ISO8859_4"),
    ISO_8859_5(0, "ISO-8859-5", "ISO8859_5"),
    ISO_8859_7(0, "ISO-8859-7", "ISO8859_7"),
    ISO_8859_9(0, "ISO-8859-9", "ISO8859_9"),
    ISO_8859_13(0, "ISO-8859-13", "ISO8859_13"),
    ISO_8859_15(0, "ISO-8859-15", "ISO8859_15"),
    KOI_8_R(0, "KOI8-R", "KOI8_R"),
    KOI_8_U(0, "KOI8-U", "KOI8_U"),
    US_ASCII(0, "US-ASCII", "ASCII"),
    UTF_16(0, "UTF-16", "UTF-16"),
    UTF_16BE(0, "UTF-16BE", "UnicodeBigUnmarked"),
    UTF_16LE(0, "UTF-16LE", "UnicodeLittleUnmarked"),
    UTF_32(0, "UTF-32", "UTF_32"),
    UTF_32BE(0, "UTF-32BE", "UTF_32BE"),
    UTF_32LE(0, "UTF-32LE", "UTF_32LE"),
    X_UTF_16LE_BOM(0, "x-UTF-16LE-BOM", "UnicodeLittle"),
    X_UTF_32BE_BOM(0, "x-UTF-32BE-BOM", "UTF_32BE_BOM"),
    X_UTF_32LE_BOM(0, "x-UTF-32LE-BOM", "UTF_32LE_BOM"),
    UNICODE_BIG(0, "Not available", "UnicodeBig"),
    EBCDIC(0, "IBM1047", "Cp1047");

    private final String key;
    private final byte code;
    private final String keyLangApi;

    private EncodingType(byte code, String key, String keyLangApi) {
        this.code = code;
        this.key = key;
        this.keyLangApi = keyLangApi;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getKeyLangApi() {
        return this.keyLangApi;
    }

    @Override
    public String getKeyNioApi() {
        return this.key;
    }

    public static IEncodingType getByCode(byte code) {
        for (EncodingType type : EncodingType.values()) {
            if (type.code == 0 || type.code != code) continue;
            return type;
        }
        return null;
    }

    public static IEncodingType getByName(String name) {
        for (EncodingType type : EncodingType.values()) {
            if (!type.key.equalsIgnoreCase(name) && !type.keyLangApi.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

