/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.anwiba.commons.reference.utilities.IoUtilities;

public class ZipUtilities {
    public static void extract(File resource, File targetFolder) throws IOException {
        int BUFFER = 2048;
        try (FileInputStream fis = new FileInputStream(resource);){
            ZipEntry entry;
            File folder = targetFolder;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(folder, ZipUtilities.resolveSpecialPathNames(entry.getName()));
                if (entry.isDirectory()) {
                    file.mkdir();
                    continue;
                }
                byte[] data = new byte[2048];
                try (FileOutputStream fos = new FileOutputStream(file);
                     BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);){
                    int count;
                    while ((count = zis.read(data, 0, 2048)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                }
            }
        }
        catch (IOException exception) {
            throw new IOException("extract of resource '" + resource + "' faild", exception);
        }
    }

    static String resolveSpecialPathNames(String name) throws IOException {
        Path normalize = new File(name).toPath().normalize();
        ArrayList items = new ArrayList();
        normalize.forEach(p -> Optional.of(p).filter(i -> !i.equals(Paths.get("..", new String[0]))).ifPresent(i -> items.add(i)));
        if (items.size() != normalize.getNameCount()) {
            throw new IOException("Entry is outside of the target folder '" + name + "'");
        }
        return items.stream().map(p -> p.toString()).reduce(null, (i, s) -> i == null ? s : i + File.separator + s);
    }

    public static void zipFile(File sourceFile, File destinationFile) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);){
            ZipUtilities.zipFile(sourceFile, (OutputStream)fileOutputStream);
        }
    }

    public static void zipFile(File sourceFile, OutputStream destinationOutputStream) throws IOException {
        ZipUtilities.zipFile(new File[]{sourceFile}, destinationOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File[] sourceFiles, OutputStream destinationOutputStream) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(destinationOutputStream);
            for (File sourceFile : sourceFiles) {
                if (!sourceFile.exists()) {
                    throw new IllegalArgumentException("Source file '" + sourceFile + "' does not exist.");
                }
                if (sourceFile.isFile()) {
                    ZipUtilities.addFile(zipOutputStream, sourceFile, "");
                    continue;
                }
                ZipUtilities.addDirectory(zipOutputStream, sourceFile, "");
            }
            zipOutputStream.finish();
        }
        catch (Throwable throwable) {
            IoUtilities.close(zipOutputStream);
            throw throwable;
        }
        IoUtilities.close((Closeable)zipOutputStream);
    }

    private static void addFile(ZipOutputStream zipOutputStream, File sourceFile, String folder) throws IOException {
        try (FileInputStream inFis = new FileInputStream(sourceFile);){
            ZipEntry zipentry = new ZipEntry(folder + sourceFile.getName());
            zipentry.setMethod(8);
            zipOutputStream.putNextEntry(zipentry);
            IoUtilities.pipe((InputStream)inFis, (OutputStream)zipOutputStream);
        }
    }

    private static void addDirectory(ZipOutputStream zipOutputStream, File directory, String folder) throws IOException {
        File[] files;
        for (File inFile : files = directory.listFiles()) {
            if (inFile.isFile()) {
                ZipUtilities.addFile(zipOutputStream, inFile, folder);
                continue;
            }
            ZipUtilities.addDirectory(zipOutputStream, inFile, folder + inFile.getName() + "/");
        }
    }
}

