/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io.url;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.io.url.AuthorityBuilder;
import net.anwiba.commons.utilities.io.url.IAuthentication;
import net.anwiba.commons.utilities.io.url.IAuthority;
import net.anwiba.commons.utilities.io.url.IHost;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.io.url.Url;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.Parameter;

public class UrlBuilder {
    List<String> scheme = new ArrayList<String>();
    private String username;
    private String password;
    private String hostName;
    private Integer port;
    List<IParameter> parameters = new ArrayList<IParameter>();
    List<String> path = new ArrayList<String>();
    private final String fragment;

    public UrlBuilder(List<String> scheme, IHost host, List<String> path) {
        this.scheme.addAll(scheme);
        this.hostName = (String)Optional.of((Object)host).convert(a -> a.getName()).get();
        this.port = (Integer)Optional.of((Object)host).convert(a -> a.getPort()).get();
        this.username = null;
        this.password = null;
        this.path.addAll(path);
        this.fragment = null;
    }

    public UrlBuilder(IUrl url) {
        this.scheme.addAll(url.getScheme());
        IAuthentication authentication = url.getAuthentication();
        this.username = (String)Optional.of((Object)authentication).convert(a -> a.getUsername()).get();
        this.password = (String)Optional.of((Object)authentication).convert(a -> a.getPassword()).get();
        IHost host = url.getHost();
        this.hostName = (String)Optional.of((Object)host).convert(a -> a.getName()).get();
        this.port = (Integer)Optional.of((Object)host).convert(a -> a.getPort()).get();
        url.getQuery().forEach(p -> this.parameters.add((IParameter)p));
        this.path.addAll(url.getPath());
        this.fragment = url.getFragment();
    }

    public IUrl build() {
        IAuthority authority = new AuthorityBuilder().setUsername(this.username).setPassword(this.password).setHostName(this.hostName).setPort(this.port).build();
        return new Url(this.scheme, authority, this.path, this.parameters, this.fragment);
    }

    public UrlBuilder addQueryParameter(IParameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public UrlBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public UrlBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public UrlBuilder setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public UrlBuilder setPort(Integer port) {
        this.port = port;
        return this;
    }

    public UrlBuilder addQueryParameter(String name, String value) {
        this.addQueryParameter(Parameter.of(name, value));
        return this;
    }
}

