/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io.url.parser;

import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.io.url.Url;
import net.anwiba.commons.utilities.io.url.parser.AuthorityBuilder;
import net.anwiba.commons.utilities.io.url.parser.PathBuilder;
import net.anwiba.commons.utilities.io.url.parser.ProtocolBuilder;
import net.anwiba.commons.utilities.io.url.parser.QueryBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;

public class UrlParser {
    public IUrl parse(String string) throws CreationException {
        if (StringUtilities.isNullOrTrimmedEmpty(string)) {
            return null;
        }
        ProtocolBuilder protocolBuilder = new ProtocolBuilder();
        AuthorityBuilder authorityBuilder = new AuthorityBuilder();
        PathBuilder pathBuilder = new PathBuilder();
        QueryBuilder queryBuilder = new QueryBuilder();
        StringBuilder fragmentBuilder = new StringBuilder();
        State state = State.PROTOCOL;
        block8: for (int i = 0; i < string.length(); ++i) {
            char character = string.charAt(i);
            switch (state) {
                case PROTOCOL: {
                    state = this.protocol(protocolBuilder, character);
                    continue block8;
                }
                case RESOURCE: {
                    state = this.resource(pathBuilder, character);
                    continue block8;
                }
                case AUTHORITY: {
                    state = this.authority(authorityBuilder, pathBuilder, character);
                    continue block8;
                }
                case PATH: {
                    state = this.path(pathBuilder, character);
                    continue block8;
                }
                case QUERY: {
                    state = this.query(queryBuilder, character);
                    continue block8;
                }
                case FRAGMENT: {
                    fragmentBuilder.append(character);
                }
            }
        }
        return new Url(protocolBuilder.build(), authorityBuilder.build(), pathBuilder.build(), queryBuilder.build(), (String)Optional.of((Object)fragmentBuilder.toString()).accept(f -> !StringUtilities.isNullOrEmpty(f)).get());
    }

    private State query(QueryBuilder queryBuilder, char character) {
        switch (character) {
            case '#': {
                return State.FRAGMENT;
            }
        }
        queryBuilder.add(character);
        return State.QUERY;
    }

    private State path(PathBuilder pathBuilder, char character) {
        switch (character) {
            case '?': {
                return State.QUERY;
            }
            case '#': {
                return State.FRAGMENT;
            }
        }
        pathBuilder.add(character);
        return State.PATH;
    }

    private State authority(AuthorityBuilder authorityBuilder, PathBuilder pathBuilder, char character) {
        switch (character) {
            case '/': {
                pathBuilder.add(character);
                return State.PATH;
            }
            case '?': {
                return State.QUERY;
            }
            case '#': {
                return State.FRAGMENT;
            }
        }
        authorityBuilder.add(character);
        return State.AUTHORITY;
    }

    private State resource(PathBuilder pathBuilder, char character) {
        switch (character) {
            case '/': {
                return State.AUTHORITY;
            }
            case '?': {
                return State.QUERY;
            }
            case '#': {
                return State.FRAGMENT;
            }
        }
        pathBuilder.add(character);
        return State.PATH;
    }

    private State protocol(ProtocolBuilder protocolBuilder, char character) {
        switch (character) {
            case '/': {
                return State.RESOURCE;
            }
        }
        protocolBuilder.add(character);
        return State.PROTOCOL;
    }

    private static enum State {
        PROTOCOL,
        RESOURCE,
        AUTHORITY,
        PATH,
        QUERY,
        FRAGMENT;

    }
}

