/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import net.anwiba.commons.utilities.math.Angle;

public class AngleFormat
extends Format {
    private static final long serialVersionUID = 1L;

    public static final AngleFormat getInstance() {
        return new AngleFormat();
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return toAppendTo;
        }
        StringBuffer buffer = new StringBuffer();
        buffer = this.getAngle(obj);
        if (toAppendTo == null) {
            return buffer;
        }
        if (pos == null) {
            return toAppendTo.append(buffer);
        }
        return toAppendTo.replace(pos.getBeginIndex(), pos.getEndIndex(), buffer.toString());
    }

    private StringBuffer getAngle(Object obj) {
        StringBuffer buffer = new StringBuffer();
        if (obj instanceof Angle) {
            Angle angle = (Angle)obj;
            double degree = angle.degree();
            this.toString(buffer, degree);
        }
        if (obj instanceof Double) {
            double angle = (Double)obj;
            this.toString(buffer, angle);
        }
        return buffer;
    }

    public void toString(StringBuffer buffer, double value) {
        DecimalFormat sf = new DecimalFormat("0000");
        double angle = value;
        String degree = String.format("%4d", (int)angle);
        if (angle < 0.0) {
            angle *= -1.0;
        }
        angle = (angle - (double)((int)angle)) * 60.0;
        String minutes = String.format("%02d", (int)angle);
        angle = (angle - (double)((int)angle)) * 60.0;
        String seconds = String.format("%02d", (int)angle);
        angle = (angle - (double)((int)angle)) * 10000.0;
        String ms = sf.format((int)angle);
        buffer.append(degree).append("\u00b0").append(minutes).append("'").append(seconds).append("\"").append(".").append(ms);
    }

    public Double parse(String text) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Double result = this.parse(text, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("Unparseable string: \"" + text + "\"", pos.getErrorIndex());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Double parse(String text, ParsePosition pos) {
        if (text == null) {
            return null;
        }
        if (pos == null) {
            return null;
        }
        int index = pos.getIndex();
        if (index == text.length()) {
            return null;
        }
        Object value = "";
        Object degree = null;
        Object minutes = null;
        Object seconds = null;
        while (text.length() > index) {
            if (text.charAt(index) == ' ') {
                if (((String)value).length() > 0) {
                    if (degree == null) {
                        if (((String)value).equals("+") || ((String)value).equals("-")) {
                            value = (String)value + "0";
                        }
                        degree = value;
                        value = "";
                    } else {
                        if (minutes != null) {
                            pos.setErrorIndex(index);
                            return null;
                        }
                        minutes = value;
                    }
                }
            } else if (text.charAt(index) == '-' || text.charAt(index) == '+') {
                if (degree != null) {
                    pos.setErrorIndex(index);
                    return null;
                }
                value = (String)value + text.charAt(index);
            } else if (text.charAt(index) >= '0' && '9' >= text.charAt(index)) {
                value = (String)value + text.charAt(index);
            } else if (text.charAt(index) == '.' || text.charAt(index) == '\u00b0') {
                if (degree != null) {
                    pos.setErrorIndex(index);
                    return null;
                }
                if (((String)value).length() > 0) {
                    if (((String)value).equals("+") || ((String)value).equals("-")) {
                        value = (String)value + "0";
                    }
                    degree = value;
                } else {
                    degree = "0";
                }
                value = "";
            } else if (text.charAt(index) == '\'') {
                if (minutes != null) {
                    pos.setErrorIndex(index);
                    return null;
                }
                if (((String)value).length() > 2) {
                    pos.setErrorIndex(index);
                    return null;
                }
                if (degree == null) {
                    degree = "0";
                }
                minutes = value;
                value = "";
            } else {
                if (text.charAt(index) != '\"') {
                    pos.setErrorIndex(index);
                    return null;
                }
                if (seconds != null) {
                    pos.setErrorIndex(index);
                    return null;
                }
                if (((String)value).length() > 2) {
                    pos.setErrorIndex(index);
                    return null;
                }
                if (degree == null) {
                    degree = "0";
                }
                if (minutes == null) {
                    minutes = "0";
                }
                seconds = value;
                value = "";
            }
            ++index;
        }
        if (((String)value).length() > 0) {
            if (degree == null) {
                if (((String)value).equals("+") || ((String)value).equals("-")) {
                    value = (String)value + "0";
                }
                degree = value;
            } else {
                if (minutes != null) {
                    pos.setErrorIndex(index);
                    return null;
                }
                minutes = value;
            }
        }
        double angle = 0.0;
        if (seconds != null) {
            angle = Double.parseDouble(seconds);
            angle /= 60.0;
        }
        if (minutes != null) {
            angle += Double.parseDouble((String)minutes);
        }
        angle /= 60.0;
        if (degree != null) {
            angle += Double.parseDouble((String)degree);
        }
        pos.setIndex(index);
        return angle %= 360.0;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }
}

