/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.name;

import net.anwiba.commons.utilities.name.INameConverter;
import net.anwiba.commons.utilities.string.StringUtilities;
import org.apache.commons.lang3.CharSet;

public class NameConverter
implements INameConverter {
    private static final String N = "n";
    ISupplier<String, String> prefixSupplier = new ISupplier<String, String>(){

        @Override
        public String supply(String input) {
            return NameConverter.N;
        }
    };

    @Override
    public String convert(String input) {
        if (StringUtilities.isNullOrTrimmedEmpty(input)) {
            return N;
        }
        StringBuilder builder = new StringBuilder();
        boolean whitespaceFlag = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = this.substitute(input.charAt(i));
            if ('_' == c) {
                whitespaceFlag = true;
                continue;
            }
            if (builder.length() == 0 && CharSet.ASCII_NUMERIC.contains(c)) {
                builder.append(this.prefixSupplier.supply(input));
            }
            if (builder.length() > 0 && whitespaceFlag) {
                builder.append('_');
            }
            whitespaceFlag = false;
            builder.append(c);
        }
        String string = builder.toString();
        return StringUtilities.isNullOrTrimmedEmpty(string) ? N : string;
    }

    private char substitute(char c) {
        if (CharSet.ASCII_NUMERIC.contains(c)) {
            return c;
        }
        if (CharSet.ASCII_ALPHA.contains(c)) {
            return c;
        }
        return '_';
    }

    static interface ISupplier<I, O> {
        public O supply(I var1);
    }
}

