/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.property;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class PropertyUtilities {
    private static ILogger logger = Logging.getLogger(PropertyUtilities.class);

    public static Properties getProperties(String propertiesFile) {
        Properties properties = new Properties(System.getProperties());
        if (propertiesFile != null) {
            try (FileInputStream inputstream = new FileInputStream(propertiesFile);){
                properties.load(inputstream);
                System.setProperties(properties);
            }
            catch (FileNotFoundException exception) {
                logger.log(ILevel.WARNING, propertiesFile + " ist nicht vorhanden");
                return null;
            }
            catch (IOException exception) {
                logger.log(ILevel.WARNING, propertiesFile + " konnte nicht geladen werden");
                return null;
            }
        }
        return properties;
    }
}

