/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.string.IStringSubstituter;
import net.anwiba.commons.utilities.string.StringUtilities;

public class StringToSystemPropertiesSubstituter
implements IStringSubstituter {
    private final List<IConverter<String, String, RuntimeException>> converters = new LinkedList<IConverter<String, String, RuntimeException>>();

    public StringToSystemPropertiesSubstituter(List<String> propertyNames) {
        new LinkedHashSet<String>(propertyNames).forEach(property -> this.converters.add((IConverter<String, String, RuntimeException>)((IConverter)string -> {
            String value = System.getProperty(property);
            if (StringUtilities.isNullOrTrimmedEmpty(value) || !string.startsWith(value)) {
                return string;
            }
            return "$SYSTEM{" + property + "}" + string.substring(value.length(), string.length());
        })));
    }

    @Override
    public String substitute(String string) {
        String value = string;
        for (IConverter<String, String, RuntimeException> converter : this.converters) {
            value = (String)converter.convert((Object)value);
        }
        return value;
    }
}

