/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.time;

import java.util.TimeZone;
import net.anwiba.commons.lang.optional.Optional;

public class TimeZoneUtilities {
    private static final int MIM_PER_HOUR = 60;
    private static final int MILLISECONDS_PER_MIN = 60000;
    private static final int MILLISECONDS_PER_HOUR = 3600000;

    public static TimeZone getSystemTimeZone() {
        return TimeZone.getDefault();
    }

    public static TimeZone getUserTimeZone() {
        return (TimeZone)Optional.of((Object)System.getProperty("user.timezone")).convert(z -> TimeZone.getTimeZone(z)).getOr(() -> TimeZone.getDefault());
    }

    public static void setTimeZoneToGmt_NNN() {
        TimeZone.setDefault(TimeZone.getTimeZone(TimeZoneUtilities.getTimeZoneToGmt_NNN()));
    }

    private static String getTimeZoneToGmt_NNN() {
        int rawOffset = TimeZoneUtilities.getRawOffset();
        return "GMT" + TimeZoneUtilities.toString(rawOffset);
    }

    private static int getRawOffset() {
        return TimeZone.getDefault().getRawOffset();
    }

    private static String toString(int rawOffset) {
        if (rawOffset == 0) {
            return "";
        }
        int hours = rawOffset / 3600000;
        int min = rawOffset / 60000 - hours * 60;
        String string = String.valueOf(hours) + ":" + String.valueOf(min);
        return rawOffset < 0 ? string : "+" + string;
    }
}

