/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities;

import java.util.HashSet;
import net.anwiba.commons.lang.functional.IAcceptor;

public class ThrowableUtilities {
    public static boolean validate(Exception exception, IAcceptor<Throwable> acceptor) {
        return ThrowableUtilities.validate(new HashSet<Throwable>(), exception, acceptor);
    }

    private static boolean validate(HashSet<Throwable> visited, Throwable exception, IAcceptor<Throwable> acceptor) {
        if (visited.contains(exception)) {
            return false;
        }
        visited.add(exception);
        if (acceptor.accept((Object)exception)) {
            return true;
        }
        Throwable cause = exception.getCause();
        if (cause != null && ThrowableUtilities.validate(visited, cause, acceptor)) {
            return true;
        }
        for (Throwable suppressed : exception.getSuppressed()) {
            if (!ThrowableUtilities.validate(visited, suppressed, acceptor)) continue;
            return true;
        }
        return false;
    }
}

