/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.lang;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.reference.utilities.FileUtilities;
import net.anwiba.commons.reference.utilities.IoUtilities;
import net.anwiba.commons.reference.utilities.UriUtilities;
import net.anwiba.commons.reference.utilities.UrlToUriConverter;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.io.url.parser.UrlParser;

public class ClassLoaderUtilities {
    private static ILogger logger = Logging.getLogger((String)ClassLoaderUtilities.class.getName());
    private static Map<URI, Manifest> manifests = new HashMap<URI, Manifest>();
    private static Set<String> licenseFileNames = new HashSet<String>();
    private static Set<String> readMeFileNames;
    private static Set<String> authorsNames;
    private static Set<String> newsNames;

    public static void addToClassPath(ClassLoader classLoader, String name) throws IOException {
        ClassLoaderUtilities.addToClassPath(classLoader, new File(name));
    }

    public static void addToClassPath(ClassLoader classLoader, File path) throws IOException {
        File[] files;
        if (path.isDirectory() && (files = ClassLoaderUtilities.listJarFiles(path)) != null && files.length != 0) {
            for (File file : files) {
                ClassLoaderUtilities.addToClassPath(classLoader, file);
            }
            return;
        }
        ClassLoaderUtilities.addToClassPath(classLoader, path.toURI().toURL());
    }

    private static File[] listJarFiles(File path) {
        File[] files = path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String extension = FileUtilities.getExtension((File)file);
                return "jar".equalsIgnoreCase(extension) || "zip".equalsIgnoreCase(extension);
            }
        });
        return files;
    }

    public static void addToClassPath(ClassLoader classLoader, URI uri) throws IOException {
        ClassLoaderUtilities.addToClassPath(classLoader, uri.toURL());
    }

    public static void addToClassPath(ClassLoader classLoader, final URL url) throws IOException {
        if (!(classLoader instanceof URLClassLoader)) {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            throw new IOException("Error, could not add URL to system classloader");
        }
        final URLClassLoader sysloader = (URLClassLoader)classLoader;
        final Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class[] parameters = new Class[]{URL.class};
                        Method method = sysclass.getDeclaredMethod("addURL", parameters);
                        method.setAccessible(true);
                        method.invoke((Object)sysloader, url);
                    }
                    catch (SecurityException exception) {
                        throw new RuntimeException(exception);
                    }
                    catch (NoSuchMethodException exception) {
                        throw new RuntimeException(exception);
                    }
                    catch (IllegalArgumentException exception) {
                        throw new RuntimeException(exception);
                    }
                    catch (IllegalAccessException exception) {
                        throw new RuntimeException(exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new RuntimeException(exception);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException t) {
            throw new IOException("Error, could not add URL to system classloader", t);
        }
    }

    public static String getClassPath(ClassLoader classLoader) {
        URI[] classPathList = ClassLoaderUtilities.getClassPathUris(classLoader);
        StringBuilder builder = new StringBuilder();
        for (URI url : classPathList) {
            builder.append(" ");
            builder.append(url.toString());
        }
        return builder.toString();
    }

    public static Manifest getManifest(URI uri) {
        Manifest manifest;
        if (uri == null) {
            return null;
        }
        Manifest manifest2 = manifests.get(uri);
        if (manifest2 != null) {
            return manifest2;
        }
        JarInputStream jarInputStream = new JarInputStream(uri.toURL().openStream());
        try {
            manifest2 = jarInputStream.getManifest();
            if (manifest2 != null) {
                manifests.put(uri, manifest2);
            }
            manifest = manifest2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return null;
            }
        }
        jarInputStream.close();
        return manifest;
    }

    public static String getLicense(URI uri) {
        if (uri == null) {
            return null;
        }
        return ClassLoaderUtilities.getFirstFile(uri, licenseFileNames);
    }

    public static String getReadMe(URI uri) {
        if (uri == null) {
            return null;
        }
        return ClassLoaderUtilities.getFirstFile(uri, readMeFileNames);
    }

    public static String getAuthors(URI uri) {
        if (uri == null) {
            return null;
        }
        return ClassLoaderUtilities.getFirstFile(uri, authorsNames);
    }

    public static String getNews(URI uri) {
        if (uri == null) {
            return null;
        }
        return ClassLoaderUtilities.getFirstFile(uri, newsNames);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getFirstFile(URI uri, Set<String> fileNames) {
        try {
            block13: {
                block12: {
                    jarInputStream = new JarInputStream(uri.toURL().openStream());
                    try {
                        entry = jarInputStream.getNextJarEntry();
lbl5:
                        // 3 sources

                        while (entry != null) {
                            if (entry.isDirectory()) {
                                entry = jarInputStream.getNextJarEntry();
                                continue;
                            }
                            name = entry.getName();
                            if (fileNames.contains(name)) {
                                var5_9 = IoUtilities.toString((InputStream)jarInputStream, (String)"UTF-8", (long)entry.getSize());
                                break block12;
                            }
                            ** GOTO lbl-1000
                        }
                        break block13;
                    }
                    catch (NullPointerException var3_5) {
                        // empty catch block
                        break block13;
                    }
                    catch (Throwable var3_6) {
                        try {
                            jarInputStream.close();
                            throw var3_6;
                        }
                        catch (Throwable var4_8) {
                            var3_6.addSuppressed(var4_8);
                        }
                        throw var3_6;
                    }
                }
                jarInputStream.close();
                return var5_9;
lbl-1000:
                // 1 sources

                {
                    entry = jarInputStream.getNextJarEntry();
                    ** GOTO lbl5
                }
            }
            var3_4 = null;
            jarInputStream.close();
            return var3_4;
        }
        catch (IOException exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contains(URI library, String resource) {
        if (library == null) {
            return false;
        }
        try {
            block14: {
                block13: {
                    jarInputStream = new JarInputStream(library.toURL().openStream());
                    try {
                        entry = jarInputStream.getNextJarEntry();
lbl7:
                        // 3 sources

                        while (entry != null) {
                            if (entry.isDirectory()) {
                                entry = jarInputStream.getNextJarEntry();
                                continue;
                            }
                            name = entry.getName();
                            if (resource.equals(name)) {
                                var5_10 = true;
                                break block13;
                            }
                            ** GOTO lbl-1000
                        }
                        break block14;
                    }
                    catch (NullPointerException var3_5) {
                        // empty catch block
                        break block14;
                    }
                    catch (Throwable var3_7) {
                        try {
                            jarInputStream.close();
                            throw var3_7;
                        }
                        catch (Throwable var4_9) {
                            var3_7.addSuppressed(var4_9);
                        }
                        throw var3_7;
                    }
                }
                jarInputStream.close();
                return var5_10;
lbl-1000:
                // 1 sources

                {
                    entry = jarInputStream.getNextJarEntry();
                    ** GOTO lbl7
                }
            }
            var3_6 = false;
            jarInputStream.close();
            return var3_6;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public static URI[] getLibraries(Manifest manifest, String parent) {
        logger.log(ILevel.DEBUG, "parent: " + parent);
        Attributes attributes = manifest.getMainAttributes();
        String classPath = attributes.getValue("Class-Path");
        if (classPath == null) {
            return new URI[0];
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        StringTokenizer stringTokenizer = new StringTokenizer(classPath, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                logger.log(ILevel.DEBUG, "child: " + string);
                URI uri = URI.create(string);
                if (!uri.isAbsolute()) {
                    try {
                        File file = new File(parent == null ? new File(System.getProperty("user.dir")) : new File(new URI(parent)), string);
                        logger.log(ILevel.DEBUG, "add none absolute file: " + file.getCanonicalFile().toURI());
                        uris.add(file.getCanonicalFile().toURI());
                    }
                    catch (IOException exception) {
                        logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
                        uris.add(new URI(string));
                    }
                    continue;
                }
                if ("file".equalsIgnoreCase(uri.getScheme())) {
                    try {
                        logger.log(ILevel.DEBUG, "add file: " + string);
                        uris.add(new File(uri).getCanonicalFile().toURI());
                    }
                    catch (IOException exception) {
                        logger.log(ILevel.ALL, exception.getMessage(), (Throwable)exception);
                        uris.add(new URI(string));
                    }
                    continue;
                }
                logger.log(ILevel.DEBUG, "add: " + string);
                uris.add(uri);
            }
            catch (URISyntaxException e) {
                logger.log(ILevel.ALL, e.getMessage(), (Throwable)e);
            }
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public static URI[] getClassPathUris(ClassLoader classLoader) {
        logger.log(ILevel.DEBUG, classLoader.getClass().toString());
        if (!(classLoader instanceof URLClassLoader)) {
            try {
                return (URI[])Streams.of(classLoader.getResources("META-INF/MANIFEST.MF")).convert(u -> ClassLoaderUtilities.convert(u)).notNull().asArray(URI[]::new);
            }
            catch (IOException e) {
                return new URI[0];
            }
        }
        URLClassLoader sysloader = (URLClassLoader)classLoader;
        URI[] classPathList = ArrayUtilities.convert(new IConverter<URL, URI, RuntimeException>(){
            UrlToUriConverter converter = new UrlToUriConverter();

            public URI convert(URL url) {
                try {
                    URI converted = this.converter.convert(url);
                    logger.log(ILevel.DEBUG, MessageFormat.format("url {0} uri {1}", url, converted));
                    return converted;
                }
                catch (URISyntaxException exception) {
                    logger.log(ILevel.DEBUG, exception.getLocalizedMessage(), (Throwable)exception);
                    return null;
                }
            }
        }, sysloader.getURLs(), URI.class);
        return ArrayUtilities.normalize(classPathList);
    }

    private static URI convert(URL u) {
        try {
            String string = u.toString().replace("META-INF/MANIFEST.MF", "").replace("!/", "").replace("jar:", "");
            IUrl url = new UrlParser().parse(string);
            return new URI(url.toString());
        }
        catch (CreationException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static URI[] getLibraries(ClassLoader classLoader) {
        URI[] classPathUrls = ClassLoaderUtilities.getClassPathUris(classLoader);
        if (classPathUrls.length == 0) {
            return classPathUrls;
        }
        ArrayList<URI> libraryList = new ArrayList<URI>();
        for (URI uri : classPathUrls) {
            logger.log(ILevel.DEBUG, uri.toString());
            String string = uri.toString();
            int length = string.length();
            if (!string.substring(length - 4 < 0 ? 0 : length - 4, length).equalsIgnoreCase(".jar")) continue;
            logger.log(ILevel.DEBUG, "add: " + uri.toString());
            libraryList.add(uri);
        }
        ArrayList<URI> subLibraryList = new ArrayList<URI>();
        for (URI uri : libraryList) {
            URI[] classPaths;
            Manifest manifest = ClassLoaderUtilities.getManifest(uri);
            if (manifest == null) continue;
            for (URI classPath : classPaths = ClassLoaderUtilities.getLibraries(manifest, ClassLoaderUtilities.getParent(uri))) {
                logger.log(ILevel.DEBUG, classPath.toString());
                if (libraryList.contains(classPath) || classPath.isAbsolute() && "file".equalsIgnoreCase(classPath.getScheme()) && !new File(classPath).exists()) continue;
                logger.log(ILevel.DEBUG, "add: " + classPath.toString());
                subLibraryList.add(classPath);
            }
        }
        libraryList.addAll(subLibraryList);
        return libraryList.toArray(new URI[libraryList.size()]);
    }

    public static String getParent(URI uri) {
        if (uri.isAbsolute() && "file".equalsIgnoreCase(uri.getScheme())) {
            return new File(uri).getParentFile().toURI().toASCIIString();
        }
        return UriUtilities.getParentUri((URI)uri).toASCIIString();
    }

    public static File getParentFile(String folder) {
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        if (tokenizer.hasMoreTokens()) {
            String pathName = tokenizer.nextToken();
            File path = new File(pathName);
            return path.getParentFile();
        }
        if (folder != null) {
            return new File(new File(System.getProperty("user.home")), folder);
        }
        return new File(System.getProperty("user.dir"));
    }

    public static File getFile(String name, String folder) {
        String pathName;
        File path;
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        if (tokenizer.hasMoreTokens() && new File((path = new File(pathName = tokenizer.nextToken())).getParentFile(), name).exists()) {
            return new File(path.getParentFile(), name);
        }
        File file = new File(new File(System.getProperty("user.dir")), name);
        if (file.exists()) {
            return file;
        }
        if (folder != null) {
            return new File(new File(new File(System.getProperty("user.home")), folder), name);
        }
        return file;
    }

    public static File getFile(String name) {
        return ClassLoaderUtilities.getFile(name, null);
    }

    static {
        licenseFileNames.add("META-INF/LICENSE.txt");
        licenseFileNames.add("META-INF/LICENSE.md");
        licenseFileNames.add("META-INF/LICENSE");
        licenseFileNames.add("META-INF/COPYING");
        licenseFileNames.add("license/LICENSE.txt");
        licenseFileNames.add("license/LICENSE");
        licenseFileNames.add("license.html");
        licenseFileNames.add("LICENSE.txt");
        licenseFileNames.add("LICENSE");
        licenseFileNames.add("LICENSE.md");
        licenseFileNames.add("COPYING");
        readMeFileNames = new HashSet<String>();
        readMeFileNames.add("META-INF/README.txt");
        readMeFileNames.add("META-INF/README.md");
        readMeFileNames.add("META-INF/README");
        readMeFileNames.add("META-INF/NOTICE.txt");
        readMeFileNames.add("META-INF/NOTICE.md");
        readMeFileNames.add("META-INF/NOTICE");
        readMeFileNames.add("license/README.txt");
        readMeFileNames.add("license/README.md");
        readMeFileNames.add("license/README");
        readMeFileNames.add("README.txt");
        readMeFileNames.add("README.md");
        readMeFileNames.add("README");
        readMeFileNames.add("NOTICE.txt");
        readMeFileNames.add("NOTICE.md");
        readMeFileNames.add("NOTICE");
        authorsNames = new HashSet<String>();
        authorsNames.add("META-INF/AUTHORS.txt");
        authorsNames.add("META-INF/AUTHORS.md");
        authorsNames.add("META-INF/AUTHORS");
        authorsNames.add("AUTHORS.txt");
        authorsNames.add("AUTHORS.md");
        authorsNames.add("AUTHORS");
        newsNames = new HashSet<String>();
        newsNames.add("META-INF/NEWS.txt");
        newsNames.add("META-INF/NEWS.md");
        newsNames.add("META-INF/NEWS");
        newsNames.add("NEWS.txt");
        newsNames.add("NEWS.md");
        newsNames.add("NEWS");
    }
}

