/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.math;

import java.util.Objects;
import net.anwiba.commons.utilities.math.Angle;
import net.anwiba.commons.utilities.math.DirectionAngle;

public enum DirectionOrientation {
    MATH(0.0, Orientation.COUNTERCLOCKWISE),
    GEOGRAPHIC_NORTH(1.5707963267948966, Orientation.CLOCKWISE);

    private double deltaInDegreeToMath;
    private Orientation orientation;

    private DirectionOrientation(double deltaInRadianToMath, Orientation orientation) {
        this.deltaInDegreeToMath = deltaInRadianToMath;
        this.orientation = orientation;
    }

    Angle toMath(Angle value) {
        return Angle.radian(this.orientation.factor * value.radian() + this.deltaInDegreeToMath);
    }

    Angle fromMath(Angle value) {
        return Angle.radian(this.orientation.factor * (value.radian() - this.deltaInDegreeToMath));
    }

    public static DirectionAngle convertTo(DirectionAngle direction, DirectionOrientation orientation) {
        if (Objects.equals((Object)direction.getOrientation(), (Object)orientation)) {
            return direction;
        }
        Angle mathDirectionAngle = direction.getOrientation().toMath(direction.getAngle());
        return DirectionAngle.of(orientation.fromMath(mathDirectionAngle), orientation);
    }

    public static DirectionAngle addClockwise(DirectionAngle direction, Angle angle) {
        DirectionOrientation orientation = direction.getOrientation();
        Angle mathDirectionAngle = orientation.toMath(direction.getAngle());
        return DirectionAngle.of(orientation.fromMath(mathDirectionAngle.subtract(angle)), orientation);
    }

    public static DirectionAngle subtractClockwise(DirectionAngle direction, Angle angle) {
        DirectionOrientation orientation = direction.getOrientation();
        Angle mathDirectionAngle = orientation.toMath(direction.getAngle());
        return DirectionAngle.of(orientation.fromMath(mathDirectionAngle.add(angle)), orientation);
    }

    public static Angle between(DirectionAngle direction, DirectionAngle other) {
        double mathDirectionAngle = direction.getOrientation().toMath(direction.getAngle().nonNegativ()).radian();
        double mathOtherAngle = other.getOrientation().toMath(other.getAngle().nonNegativ()).radian();
        if (mathDirectionAngle < mathDirectionAngle) {
            return Angle.radian(mathDirectionAngle - mathOtherAngle);
        }
        return Angle.radian(Math.PI * 2 - mathDirectionAngle + mathOtherAngle);
    }

    public static enum Orientation {
        CLOCKWISE(-1.0),
        COUNTERCLOCKWISE(1.0);

        private final double factor;

        private Orientation(double factor) {
            this.factor = factor;
        }
    }
}

