/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.name;

import java.util.ArrayList;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.name.INamesConverter;
import net.anwiba.commons.utilities.name.LowerCaseNameConverter;
import net.anwiba.commons.utilities.name.NameConverter;
import net.anwiba.commons.utilities.name.UniqueNameBuilder;
import net.anwiba.commons.utilities.name.UpperCaseNameConverter;

public class NamesConverter
implements INamesConverter {
    private final UniqueNameBuilder nameBuilder;

    public static INamesConverter createLowerCaseFactory(int maximumLength) {
        return new NamesConverter(new LowerCaseNameConverter(), maximumLength);
    }

    public static INamesConverter createUpperCaseFactory(int maximumLength) {
        return new NamesConverter(new UpperCaseNameConverter(), maximumLength);
    }

    public static INamesConverter create(int maximumLength) {
        return new NamesConverter(new NameConverter(), maximumLength);
    }

    private NamesConverter(IConverter<String, String, RuntimeException> nameConverter, int maximumLength) {
        this.nameBuilder = new UniqueNameBuilder(maximumLength, nameConverter, new ArrayList<String>());
    }

    @Override
    public String convert(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.nameBuilder.build(columnName);
    }
}

