/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.property.IProperty;
import net.anwiba.commons.utilities.property.PropertiesBuilder;

public final class Properties
implements IProperties {
    private static final long serialVersionUID = 655956184779585973L;
    private final List<String> names = new ArrayList<String>();
    private final List<IProperty> properties = new ArrayList<IProperty>();
    private final Map<String, IProperty> map = new HashMap<String, IProperty>();

    public static PropertiesBuilder builder() {
        return new PropertiesBuilder();
    }

    public Properties(List<IProperty> properties) {
        for (IProperty property : properties) {
            this.names.add(property.getName());
            this.map.put(property.getName(), property);
        }
        this.names.forEach(name -> this.properties.add(this.map.get(name)));
    }

    @Override
    public int getNumberOfProperties() {
        return this.properties.size();
    }

    @Override
    public IProperty getProperty(int index) {
        return this.properties.get(index);
    }

    @Override
    public IProperties adapt(int index, IProperty property) {
        IProperty[] array = this.properties.toArray(new IProperty[this.properties.size()]);
        array[index] = property;
        return new Properties(Arrays.asList(array));
    }

    @Override
    public Iterable<IProperty> properties() {
        return this.properties;
    }

    @Override
    public Iterable<String> getNames() {
        return this.names;
    }

    @Override
    public String getValue(String name) throws RuntimeException {
        if (!this.map.containsKey(name)) {
            return null;
        }
        return this.map.get(name).getValue();
    }

    @Override
    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public String getValueOrDefault(String name, String defaultValue) {
        if (!this.map.containsKey(name)) {
            return defaultValue;
        }
        return this.map.get(name).getValue();
    }
}

