/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.property;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.anwiba.commons.lang.stream.Streams;
import net.anwiba.commons.utilities.property.IProperties;
import net.anwiba.commons.utilities.property.IProperty;
import net.anwiba.commons.utilities.property.Properties;
import net.anwiba.commons.utilities.property.Property;

public final class PropertiesBuilder {
    private final Map<String, IProperty> parameters = new LinkedHashMap<String, IProperty>();

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(IProperties properties) {
        Streams.of(properties.properties()).foreach(p -> this.parameters.put(p.getName(), (IProperty)p));
    }

    public PropertiesBuilder add(String name, String value) {
        return this.add(new Property(name, value));
    }

    public PropertiesBuilder add(IProperty parameter) {
        this.parameters.put(parameter.getName(), parameter);
        return this;
    }

    public IProperties build() {
        return new Properties(new ArrayList<IProperty>(this.parameters.values()));
    }
}

