/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.util.HashMap;
import java.util.regex.Pattern;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.utilities.provider.INamedValueProvider;
import net.anwiba.commons.utilities.string.IStringAppender;
import net.anwiba.commons.utilities.string.IStringResolver;
import net.anwiba.commons.utilities.string.StringAppender;
import net.anwiba.commons.utilities.string.StringResolver;

public class StringResolverBuilder {
    private final HashMap<String, String> map = new HashMap();
    private IStringAppender errorHandler = new StringAppender();
    private Pattern pattern = IStringResolver.PLACEHOLDER_PATTERN;

    public StringResolverBuilder errorHandler(IStringAppender errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public StringResolverBuilder pattern(String pattern) {
        return this.pattern(Pattern.compile(pattern));
    }

    public StringResolverBuilder pattern(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public StringResolverBuilder optional(String name, String value) {
        this.map.put(name, value);
        return this;
    }

    public StringResolverBuilder add(String name, String value) {
        Ensure.ensureArgumentNotNull((Object)name);
        Ensure.ensureArgumentNotNull((Object)value);
        return this.optional(name, value);
    }

    public IStringResolver build() {
        return new StringResolver(this.errorHandler, new INamedValueProvider<String, RuntimeException>(){

            @Override
            public String getValue(String name) throws RuntimeException {
                return StringResolverBuilder.this.map.get(name);
            }

            @Override
            public Iterable<String> getNames() {
                return StringResolverBuilder.this.map.keySet();
            }
        }, this.pattern);
    }
}

