/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.string.IStringPart;
import net.anwiba.commons.utilities.string.StringAppender;
import net.anwiba.commons.utilities.string.StringPart;
import org.apache.commons.lang3.text.WordUtils;

public class StringUtilities {
    public static boolean isNumericValue(String text) {
        if (StringUtilities.isNullOrTrimmedEmpty(text)) {
            return false;
        }
        Locale local = Locale.getDefault();
        if (StringUtilities.isNumericValue(text, local)) {
            return true;
        }
        return StringUtilities.isNumericValue(text, Locale.US);
    }

    public static boolean isNumericValue(String text, Locale local) {
        String grouped;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(local);
        char groupingSeparator = decimalFormatSymbols.getGroupingSeparator();
        char decimalSeparator = decimalFormatSymbols.getDecimalSeparator();
        String ungrouped = "[+-]?[0-9]+[" + decimalSeparator + "]?[0-9]*([eE][-+]?[0-9]+)?";
        String patternString = ungrouped + "|" + (grouped = "[+-]?[0-9]{1,3}+(" + groupingSeparator + "[0-9]{3}+)*[" + decimalSeparator + "]?[0-9]*");
        Pattern p = Pattern.compile(patternString);
        Matcher m = p.matcher(text.trim());
        return m.matches();
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isNullOrTrimmedEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static boolean trimedEquals(String org, String other) {
        return ObjectUtilities.equals((Object)StringUtilities.getTrimed(org), (Object)StringUtilities.getTrimed(other));
    }

    private static String getTrimed(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static boolean trimedAndUpperCaseEquals(String org, String other) {
        return ObjectUtilities.equals((Object)StringUtilities.getTrimedAndUpperCase(org), (Object)StringUtilities.getTrimedAndUpperCase(other));
    }

    private static String getTrimedAndUpperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().toUpperCase();
    }

    public static String repeatString(String string, int length) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static String createUniqueName(String prefix, String[] names) {
        return StringUtilities.createUniqueName(prefix, new HashSet<String>(Arrays.asList(names)));
    }

    public static String createUniqueName(String string, Set<String> names) {
        int counter = -1;
        boolean flag = true;
        for (String name : names) {
            if (!name.toUpperCase().matches(StringUtilities.convertToRegEx(string.toUpperCase()) + "\\d*")) continue;
            if (name.toUpperCase().matches(string.toUpperCase())) {
                counter = Math.max(0, counter);
                flag = false;
                continue;
            }
            counter = Math.max(counter, Integer.valueOf(name.substring(string.length())));
        }
        return string + (flag || counter == -1 ? "" : String.valueOf(counter + 1));
    }

    public static String createConstantsName(String name) {
        return StringUtilities.convertToVariable(StringUtilities.removeWhiteSpaces(StringUtilities.removeAllControlCharacter(name))).toUpperCase();
    }

    private static String convertToVariable(String string) {
        StringBuilder builder = new StringBuilder();
        char[] charArray = string.toCharArray();
        if (!Character.isUpperCase(charArray[0]) && !Character.isLowerCase(charArray[0])) {
            builder.append("C");
        }
        block3: for (char c : charArray) {
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    builder.append('_');
                    continue block3;
                }
                default: {
                    builder.append(c);
                    continue block3;
                }
            }
        }
        return builder.toString();
    }

    private static String convertToRegEx(String string) {
        StringBuilder builder = new StringBuilder();
        block3: for (char c : string.toCharArray()) {
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    builder.append('\\');
                    builder.append(c);
                    continue block3;
                }
                default: {
                    builder.append(c);
                    continue block3;
                }
            }
        }
        return builder.toString();
    }

    public static String removeEqualEnd(String path, String descriptionFile) {
        return net.anwiba.commons.reference.utilities.StringUtilities.removeEqualEnd((String)path, (String)descriptionFile);
    }

    public static String getStringAfterLastChar(String s, char separatorChar) {
        return net.anwiba.commons.reference.utilities.StringUtilities.getStringAfterLastChar((String)s, (char)separatorChar);
    }

    public static String getStringBeforLastChar(String s, char separatorChar) {
        return net.anwiba.commons.reference.utilities.StringUtilities.getStringBeforLastChar((String)s, (char)separatorChar);
    }

    public static boolean containsIgnoreCase(String value, String ... strings) {
        for (String string : strings) {
            if (!StringUtilities.equalsIgnoreCase(value, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String value, String ... strings) {
        for (String string : strings) {
            if (!Objects.equals(value, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String value, String other) {
        return value == null ? other == null : value.equalsIgnoreCase(other);
    }

    public static List<IStringPart> getStringPositions(String text, String condition) {
        ArrayList<IStringPart> positions = new ArrayList<IStringPart>();
        if (StringUtilities.isNullOrEmpty(condition) || StringUtilities.isNullOrEmpty(text)) {
            return positions;
        }
        int position = 0;
        for (int i = 0; i < text.length(); ++i) {
            int index = i - position;
            if (text.charAt(i) == condition.charAt(index)) {
                if (index + 1 != condition.length()) continue;
                positions.add(new StringPart(position, condition.length()));
                position = i + 1;
                continue;
            }
            position = i + 1;
        }
        return positions;
    }

    public static String removeWhiteSpaces(String string) {
        StringBuilder builder = new StringBuilder();
        boolean isEscaped = false;
        boolean isLiteral = false;
        boolean isWidthespace = false;
        block6: for (char c : string.toCharArray()) {
            if (isEscaped) {
                builder.append(c);
                isEscaped = false;
                isWidthespace = false;
                continue;
            }
            if (isLiteral) {
                builder.append(c);
                isLiteral = c != '\"';
                continue;
            }
            switch (c) {
                case '\"': {
                    builder.append(c);
                    isWidthespace = false;
                    isLiteral = !isLiteral;
                    continue block6;
                }
                case '\\': {
                    builder.append(c);
                    isEscaped = true;
                    isWidthespace = false;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (isWidthespace) continue block6;
                    builder.append(' ');
                    isWidthespace = true;
                    continue block6;
                }
                case '\u0000': 
                case '\b': {
                    continue block6;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static String removeAllControlCharacter(String string) {
        StringBuilder builder = new StringBuilder();
        block3: for (char c : string.toCharArray()) {
            switch (c) {
                case '\u0000': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': {
                    continue block3;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static String getEqualPrefix(String string, String other) {
        if (string == null || other == null) {
            return "";
        }
        int length = Math.min(string.length(), other.length());
        int i = 0;
        for (i = 0; i < length && string.charAt(i) == other.charAt(i); ++i) {
        }
        if (i == 0) {
            return "";
        }
        return string.substring(0, i);
    }

    public static String[] tokens(String string, char seperator) {
        return StringUtilities.tokens(string, String.valueOf(seperator));
    }

    public static String[] tokens(String string, String seperator) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string, seperator);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String[] trimedTokens(String string, char seperator) {
        return StringUtilities.trimedTokens(string, String.valueOf(seperator));
    }

    public static String[] trimedTokens(String string, String seperator) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string, seperator);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.isEmpty()) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String setFirstTrimedCharacterToUpperCase(String string) {
        return Optional.ofNullable(string).map(s -> s.trim()).filter(s -> !s.isEmpty()).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1, s.length())).orElse(null);
    }

    public static String concatenatedString(String separator, Collection<String> values) {
        return StringUtilities.concat(separator, values.toArray(new String[values.size()]));
    }

    public static String concat(String separator, String[] values) {
        StringAppender builder = new StringAppender(separator);
        builder.append(values);
        return ((Object)builder).toString();
    }

    public static String concat(String separator, Iterable<String> values) {
        StringAppender builder = new StringAppender(separator);
        builder.append(values);
        return ((Object)builder).toString();
    }

    public static String concat(String separator, double[] values) {
        StringAppender builder = new StringAppender(separator);
        for (double value : values) {
            builder.append(String.valueOf(value));
        }
        return ((Object)builder).toString();
    }

    public static String concat(String separator, int[] values) {
        StringAppender builder = new StringAppender(separator);
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double value = nArray[i];
            builder.append(String.valueOf(value));
        }
        return ((Object)builder).toString();
    }

    public static String concat(String separator, long[] values) {
        StringAppender builder = new StringAppender(separator);
        long[] lArray = values;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            double value = lArray[i];
            builder.append(String.valueOf(value));
        }
        return ((Object)builder).toString();
    }

    public static int numberOfMatches(String string, String pattern) {
        if (StringUtilities.isNullOrEmpty(string) || StringUtilities.isNullOrEmpty(pattern)) {
            return 0;
        }
        int stringLength = string.length();
        int patternLength = pattern.length();
        if (patternLength > stringLength) {
            return 0;
        }
        int counter = 0;
        for (int i = 0; i < stringLength; ++i) {
            int j = 0;
            for (j = 0; i + j < stringLength && j < patternLength && string.charAt(i + j) == pattern.charAt(j); ++j) {
            }
            if (j != patternLength) continue;
            ++counter;
        }
        return counter;
    }

    public static String reduce(String string, int maximumNumberOfRows, int maximumColumnLength) {
        if (string == null) {
            return null;
        }
        if (string.length() < maximumColumnLength && string.indexOf("\n") < 0) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        int stringLength = string.length();
        int maximumLength = Math.min(maximumColumnLength * maximumNumberOfRows, stringLength);
        int endIndex = 0;
        for (int i = 0; i < maximumNumberOfRows; ++i) {
            int beginIndex = endIndex;
            String substring = string.substring(beginIndex, Math.min(endIndex = beginIndex + maximumColumnLength, stringLength));
            if (substring.contains("\n")) {
                endIndex = beginIndex + substring.indexOf(10) + 1;
                substring = string.substring(beginIndex, endIndex);
            }
            builder.append(substring);
            if (maximumLength <= endIndex) {
                if (maximumLength != stringLength) {
                    builder.append("...");
                }
                builder.append("</body></html>");
                return builder.toString();
            }
            builder.append("<br>");
        }
        if (maximumLength != stringLength) {
            builder.append("...");
        }
        builder.append("</body></html>");
        return builder.toString();
    }

    public static boolean in(String value, String ... values) {
        return new HashSet<String>(Arrays.asList(values)).contains(value);
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        return WordUtils.wrap((String)str, (int)wrapLength, (String)newLineStr, (boolean)wrapLongWords);
    }
}

